﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberCommend : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberCommend.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("MemberCommend_" + user.ID.ToString());

        if (dt == null)
        {
            dt = DAL.Tables.Users.Select("", "HigherUp_id = " + user.ID.ToString(), "[RegisterTime]");

            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("MemberCommend_" + user.ID.ToString(), dt);
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            int UserType = ShoveEL._Convert.StrToInt(e.Item.Cells[5].Text, 1);
            e.Item.Cells[5].Text = (UserType == 1 ? "普通会员" : "<Font color=\'Red\'>高级会员</font>");
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}