﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberDistill : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        labBalanceSum.Text = (user.Balance + user.FreezeMoney).ToString("N");
        labBalance.Text = user.Balance.ToString("N");

        if (user.Balance < 10)
        {
            tbMoney.Enabled = false;
            btnGo.Enabled = false;
        }

        if (!this.IsPostBack)
            btnGo.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信输入无误并要提取现金吗？") + "');");
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberDistill.aspx";
        base.OnInit(e);
    }
    #endregion

    protected void btnGo_Click(object sender, System.EventArgs e)
    {
        string Return = "";
        user.GetUserBalance(ref Return);

        labBalanceSum.Text = (user.Balance + user.FreezeMoney).ToString("N");
        labBalance.Text = user.Balance.ToString("N");

        double money = ShoveEL._Convert.StrToDouble(tbMoney.Text, 0);
        if ((money < 10) || (money > user.Balance))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的提款金额。");
            return;
        }

        Return = "";
        int Result = user.Distill(money, "", ref Return);
        if ((Return != "") || (Result != 0))
        {
            GoError(Return);
            return;
        }

        labBalance.Text = user.Balance.ToString("N");
        tbMoney.Text = "";
        ShoveEL._Web.JavaScript.Alert(this.Page, "提款申请已生效，请等候工作人员进行处理。");
    }
}