﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberDistillDetail : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberDistillDetail.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("MemberDistillDetail_" + user.ID.ToString());

        if (dt == null)
        {
            dt = DAL.Tables.UserDistill.Select("", "User_id = " + user.ID.ToString(), "[DateTime] desc");

            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("MemberDistillDetail_" + user.ID.ToString(), dt);
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            double Money = ShoveEL._Convert.StrToDouble(e.Item.Cells[1].Text, 0);
            e.Item.Cells[1].Text = Money.ToString("N");

            int Result = ShoveEL._Convert.StrToInt(e.Item.Cells[2].Text, 0);
            if (Result == 0)
                e.Item.Cells[2].Text = "申请中";
            if (Result == 1)
                e.Item.Cells[2].Text = "<font color='blue'>已受理</font>";
            if (Result == -1)
                e.Item.Cells[2].Text = "<font color='red'>已拒绝</font>";
        }
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
    {
        if (e.CommandName == "Del")
        {
            string Return = "";
            int Result = user.DistillQuash(ShoveEL._Convert.StrToInt(e.Item.Cells[8].Text, 0), ref Return);
            if ((Return != "") || (Result < 0))
            {
                GoError(Return);
                return;
            }

            ShoveEL._Web.Cache.ClearCache("MemberDistillDetail_" + user.ID.ToString());
            BindData();
            return;
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}