﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;

public partial class MemberEdit1 : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        if (user.UserType == 2)
        {
            this.Response.Redirect("MemberEdit1Adv.aspx", true);
            return;
        }

        if (!this.IsPostBack)
        {
            //填充用户基本资料
            tbUserName.Text = user.Name;
            tbUserEmail.Text = user.Email;
        }

        if (user.isAlipayMember)
        {
            tbUserName.ReadOnly = true;
            tbUserEmail.ReadOnly = true;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberEdit1.aspx";
        base.OnInit(e);
    }
    #endregion

    protected void btnSave_Click(object sender, System.EventArgs e)
    {
        if (tbUserEmail.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入电子邮件地址。");
            return;
        }

        if (!ShoveEL._String.Valid.isEmail(tbUserEmail.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "电子邮件地址格式不正确。");
            return;
        }

        Users temp_user = new Users();
        user.Clone(temp_user);

        user.Email = tbUserEmail.Text.Trim();

        string Return = "";
        int result = user.EditByID(ref Return);

        if (result != 0 || Return != "")
        {
            temp_user.Clone(user);
            GoError(Return);
            return;
        }

        ShoveEL._Web.JavaScript.Alert(this.Page, "用户资料已经保存成功。");
    }
}