﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;

public partial class MemberEdit1Adv : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        if (user.UserType == 1)
        {
            this.Response.Redirect("MemberEdit1.aspx", true);
            return;
        }

        if (!this.IsPostBack)
        {
            //填充用户基本资料
            tbUserName.Text = user.Name;
            tbUserEmail.Text = user.Email;

            SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
            if (conn == null)
            {
                GoError();
                return;
            }

            FillProvince(conn);
            //FillCity(conn, ddlUserProvince.Items[0].Text);

            //填充用户高级资料
            tbUserRealityName.Text = user.RealityName;
            tbUserIDCardNumber.Text = user.IDCardNumber;
            ShoveEL.ControlExt.SetDownListBoxText(ddlUserProvince, user.Province);
            //改变省后重新填充市
            FillCity(conn, ddlUserProvince.SelectedItem.Text);
            conn.Close();
            ShoveEL.ControlExt.SetDownListBoxText(ddlUserCity, user.City);
            tbUserTelphone.Text = user.Telphone;
            tbUserMobile.Text = user.Mobile;
            if (user.MobileValid)
            {
                labMobileValidTip.Text = "已通过验证，修改手机号码必须重新验证。";
                btnMobileValid.Disabled = true;
            }
            else
            {
                labMobileValidTip.Text = "未验证，只有通过验证才能接收本站手机短信(验证信息免费)。";
                labMobileValidTip.ForeColor = System.Drawing.Color.FromName("Blue");
            }
            tbUserEmail.Text = user.Email;
            tbUserQQ.Text = user.QQ;
            tbUserAddress.Text = user.Address;
            if (user.Sex == "男")
                rbUserSexM.Checked = true;
            else if (user.Sex == "女")
                rbUserSexW.Checked = true;
            tbUserBirthDay.Text = user.BirthDay.ToShortDateString();
            cbUserisAcceptMobileMessage.Checked = user.isAcceptMobileMessage;
            cbUserisAcceptEmail.Checked = user.isAcceptEmail;
            cbUserisAcceptMessage.Checked = user.isAcceptMessage;

            btnSave.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信输入的资料无误吗？") + "');");
        }

        string MobileMessagePayType = PublicFunction.GetOptionsAsString("MobileMessagePayType", "2");
        double Price = PublicFunction.GetOptionsAsDouble("MobileMessagePrice", 0);
        if ((MobileMessagePayType == "2") && (Price > 0))
        {
            labMobileMessageCostTip.Text = " 提示：短信接收费用 " + Price.ToString("N") + " 元/条，将自动从您帐户中扣除。";
            labMobileMessageCostTip.Visible = true;
        }

        tbUserPassword2.Attributes.Add("value", tbUserPassword2.Text);

        if (user.isAlipayMember)
        {
            tbUserName.ReadOnly = true;
            tbUserEmail.ReadOnly = true;
        }

        if (!this.IsPostBack)
        {
            string Version = PublicFunction.GetVersion();

            if (Version != "1")
            {
                btnMobileValid.Visible = false;
                labMobileValidTip.Visible = false;
                cbUserisAcceptMobileMessage.Visible = false;
                labMobileMessageCostTip.Visible = false;

                cbUserisAcceptMessage.Visible = false;
            }
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberEdit1Adv.aspx";
        base.OnInit(e);
    }
    #endregion

    private void FillProvince(SqlConnection conn)
    {
        ddlUserProvince.Items.Clear();
        SqlCommand cmd = new SqlCommand("select * from Province order by [Name]", conn);
        SqlDataReader dr = cmd.ExecuteReader();
        while (dr.Read())
            ddlUserProvince.Items.Add(dr["Name"].ToString().Trim());
        dr.Close();
        if (ddlUserProvince.Items.Count > 0)
            ddlUserProvince.SelectedIndex = 0;
    }

    private void FillCity(SqlConnection conn, string ProvinceName)
    {
        ddlUserCity.Items.Clear();
        SqlCommand cmd = new SqlCommand("select * from V_City where Province=\'" + ProvinceName + "\' order by City", conn);
        SqlDataReader dr = cmd.ExecuteReader();
        while (dr.Read())
            ddlUserCity.Items.Add(dr["City"].ToString().Trim());
        dr.Close();
        if (ddlUserCity.Items.Count > 0)
            ddlUserCity.SelectedIndex = 0;
    }

    protected void ddlUserProvince_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            GoError();
            return;
        }

        FillCity(conn, ddlUserProvince.SelectedItem.Text);
        conn.Close();
    }

    protected void btnSave_Click(object sender, System.EventArgs e)
    {
        if (tbUserRealityName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入真实姓名。");
            return;
        }

        try
        {
            DateTime.Parse(tbUserBirthDay.Text.Trim());
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的生日。");
            return;
        }

        if (tbUserIDCardNumber.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入身份证号。");
            return;
        }

        if (!ShoveEL._String.Valid.isIDCardNumber(tbUserIDCardNumber.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "身份证号格式不正确。");
            return;
        }

        if (tbUserEmail.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入电子邮件地址。");
            return;
        }

        if (!ShoveEL._String.Valid.isEmail(tbUserEmail.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "电子邮件地址格式不正确。");
            return;
        }

        if (tbUserPassword2.Text != user.Password_2)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "投注密码输错误。");
            return;
        }

        Users temp_user = new Users();
        user.Clone(temp_user);

        user.RealityName = tbUserRealityName.Text.Trim();
        user.IDCardNumber = tbUserIDCardNumber.Text.Trim();
        user.Province = ddlUserProvince.SelectedItem.Text;
        user.City = ddlUserCity.SelectedItem.Text;
        user.Telphone = tbUserTelphone.Text.Trim();
        if (user.Mobile != tbUserMobile.Text.Trim())	//改变了手机号码，需要重新验证
            user.MobileValid = false;
        user.Mobile = tbUserMobile.Text.Trim();
        user.QQ = tbUserQQ.Text.Trim();
        user.Address = tbUserAddress.Text.Trim();
        user.Sex = rbUserSexM.Checked ? "男" : (rbUserSexW.Checked ? "女" : "");
        user.BirthDay = DateTime.Parse(tbUserBirthDay.Text.Trim());
        user.Email = tbUserEmail.Text.Trim();
        user.isAcceptMobileMessage = cbUserisAcceptMobileMessage.Checked;
        user.isAcceptEmail = cbUserisAcceptEmail.Checked;
        user.isAcceptMessage = cbUserisAcceptMessage.Checked;

        string Return = "";
        int result = user.EditByID(ref Return);

        if (result != 0 || Return != "")
        {
            temp_user.Clone(user);
            GoError(Return);
            return;
        }

        if (!user.MobileValid)
        {
            btnMobileValid.Disabled = false;
            labMobileValidTip.Text = "未验证，只有通过验证才能接收本站手机短信(验证信息免费)。";
            labMobileValidTip.ForeColor = System.Drawing.Color.FromName("Blue");
        }

        // 发送邮件
        if (user.UserType == 1)
        {
            if (PublicFunction.GetOptionsAsBoolean("isUserEditSendEmail", false) && (user.Email != "") && user.isAcceptEmail)
            {
                string EmailSubject = "", EmailBody = "";
                PublicFunction.GetEmailTemplate("Template\\Email\\UserEdit.txt", ref EmailSubject, ref EmailBody);
                if ((EmailSubject != "") && (EmailBody != ""))
                {
                    EmailSubject = EmailSubject.Replace("[UserName]", user.Name);

                    EmailBody = EmailBody.Replace("[UserName]", user.Name);
                    EmailBody = EmailBody.Replace("[UserPassword]", user.Password);
                    EmailBody = EmailBody.Replace("[UserEmail]", user.Email);

                    PublicFunction.SendEmail(user.Email, EmailSubject, EmailBody);
                }
            }
        }
        else
        {
            //Send Email
            if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendEmail", false) && (user.Email != "") && user.isAcceptEmail)
            {
                string EmailSubject = "", EmailBody = "";
                PublicFunction.GetEmailTemplate("Template\\Email\\UserEditAdv.txt", ref EmailSubject, ref EmailBody);
                if ((EmailSubject != "") && (EmailBody != ""))
                {
                    EmailSubject = EmailSubject.Replace("[UserRealityName]", user.RealityName);

                    EmailBody = EmailBody.Replace("[UserRealityName]", user.RealityName);
                    EmailBody = EmailBody.Replace("[UserName]", user.Name);
                    EmailBody = EmailBody.Replace("[UserPassword]", user.Password);
                    EmailBody = EmailBody.Replace("[UserPassword_2]", user.Password_2);
                    EmailBody = EmailBody.Replace("[UserEmail]", user.Email);
                    EmailBody = EmailBody.Replace("[UserIDCardNumber]", user.IDCardNumber);
                    EmailBody = EmailBody.Replace("[UserProvince]", user.Province);
                    EmailBody = EmailBody.Replace("[UserCity]", user.City);
                    EmailBody = EmailBody.Replace("[UserSex]", user.Sex);
                    EmailBody = EmailBody.Replace("[UserBirthDay]", user.BirthDay.ToShortDateString());
                    EmailBody = EmailBody.Replace("[UserTelphone]", user.Telphone);
                    EmailBody = EmailBody.Replace("[UserMobile]", user.Mobile);
                    EmailBody = EmailBody.Replace("[UserQQ]", user.QQ);
                    EmailBody = EmailBody.Replace("[UserAddress]", user.Address);
                    EmailBody = EmailBody.Replace("[UserBankType]", user.BankType);
                    EmailBody = EmailBody.Replace("[UserBankName]", user.BankName);
                    EmailBody = EmailBody.Replace("[UserBankCardNumber]", user.BankCardNumber);
                    EmailBody = EmailBody.Replace("[UserisAcceptMobileMessage]", (user.isAcceptMobileMessage ? "是" : "否"));
                    EmailBody = EmailBody.Replace("[UserisAcceptEmail]", (user.isAcceptEmail ? "是" : "否"));
                    EmailBody = EmailBody.Replace("[UserisAcceptMessage]", (user.isAcceptMessage ? "是" : "否"));

                    PublicFunction.SendEmail(user.Email, EmailSubject, EmailBody);
                }
            }
            //Send MobileMessage.......................
            if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendMobileMessage", false) && (user.Mobile != "") && user.MobileValid && user.isAcceptMobileMessage && user.GetIsAcceptMobileMessage("UserEditAdv"))
            {
                string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\UserEditAdv.txt");
                if (Body != "")
                {
                    Body = Body.Replace("[UserRealityName]", user.RealityName);
                    new JL_ISP().SendMessage(user.Mobile, Body, "", user.ID);
                }
            }
            //Send Message.......................
            if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendMessage", false) && user.isAcceptMessage)
            {
                string Body = PublicFunction.GetMessageTemplate("Template\\Message\\UserEditAdv.txt");
                if (Body != "")
                {
                    Body = Body.Replace("[UserRealityName]", user.RealityName);

                    DAL.Tables.Message.Insert(1, true, user.ID, true, 1, true, ShoveEL._String.Compress(Body), true, DateTime.Now, false, true, false);
                }
            }
        }

        ShoveEL._Web.JavaScript.Alert(this.Page, "用户资料已经保存成功。");
    }
}