﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberEdit2 : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        hlAdv.Visible = (user.UserType == 1);

        if (!this.IsPostBack)
        {
            tbUserName.Text = user.Name;
        }

        if (user.isAlipayMember)
        {
            tbUserName.ReadOnly = true;
        }

        tbOldUserPassword.Attributes.Add("value", tbOldUserPassword.Text);
        tbUserPassword.Attributes.Add("value", tbUserPassword.Text);
        tbUserPassword2.Attributes.Add("value", tbUserPassword2.Text);
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberEdit2.aspx";
        base.OnInit(e);
    }
    #endregion

    protected void btnSave_Click(object sender, System.EventArgs e)
    {
        if (tbOldUserPassword.Text == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入旧普通密码。");
            return;
        }

        if ((tbOldUserPassword.Text != user.Password) && (tbOldUserPassword.Text != ShoveEL._Security.Encrypt.GetSupperPassword()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "旧普通密码不正确。");
            return;
        }

        if (tbUserPassword.Text == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入新普通密码。");
            return;
        }

        if (tbUserPassword.Text.Length < 6)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "密码长度不足 6 位。");
            return;
        }

        if (tbUserPassword.Text != tbUserPassword2.Text)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入的两次普通密码不一致。");
            return;
        }

        Users temp_user = new Users();
        user.Clone(temp_user);

        user.Password = tbUserPassword.Text;

        string Return = "";
        int result = user.EditByID(ref Return);

        if (result != 0 || Return != "")
        {
            temp_user.Clone(user);
            GoError(Return);
            return;
        }

        //修改自动任务的 ini 文件中的密码
        if (user.ID == 1)
        {
            ShoveEL._IO.IniFile ini = new ShoveEL._IO.IniFile(this.Server.MapPath("TaskService/bin/Release/Config.ini"));
            ini.Write("Options", "UserPassword", ShoveEL._Security.Encrypt.EncryptString(user.Password));
        }

        // 发送邮件
        if (user.UserType == 1)
        {
            if (PublicFunction.GetOptionsAsBoolean("isUserEditSendEmail", false) && (user.Email != "") && user.isAcceptEmail)
            {
                string EmailSubject = "", EmailBody = "";
                PublicFunction.GetEmailTemplate("Template\\Email\\UserEdit.txt", ref EmailSubject, ref EmailBody);
                if ((EmailSubject != "") && (EmailBody != ""))
                {
                    EmailSubject = EmailSubject.Replace("[UserName]", user.Name);

                    EmailBody = EmailBody.Replace("[UserName]", user.Name);
                    EmailBody = EmailBody.Replace("[UserPassword]", user.Password);
                    EmailBody = EmailBody.Replace("[UserEmail]", user.Email);

                    PublicFunction.SendEmail(user.Email, EmailSubject, EmailBody);
                }
            }
        }
        else
        {
            //Send Email
            if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendEmail", false) && (user.Email != "") && user.isAcceptEmail)
            {
                string EmailSubject = "", EmailBody = "";
                PublicFunction.GetEmailTemplate("Template\\Email\\UserEditAdv.txt", ref EmailSubject, ref EmailBody);
                if ((EmailSubject != "") && (EmailBody != ""))
                {
                    EmailSubject = EmailSubject.Replace("[UserRealityName]", user.RealityName);

                    EmailBody = EmailBody.Replace("[UserRealityName]", user.RealityName);
                    EmailBody = EmailBody.Replace("[UserName]", user.Name);
                    EmailBody = EmailBody.Replace("[UserPassword]", user.Password);
                    EmailBody = EmailBody.Replace("[UserPassword_2]", user.Password_2);
                    EmailBody = EmailBody.Replace("[UserEmail]", user.Email);
                    EmailBody = EmailBody.Replace("[UserIDCardNumber]", user.IDCardNumber);
                    EmailBody = EmailBody.Replace("[UserProvince]", user.Province);
                    EmailBody = EmailBody.Replace("[UserCity]", user.City);
                    EmailBody = EmailBody.Replace("[UserSex]", user.Sex);
                    EmailBody = EmailBody.Replace("[UserBirthDay]", user.BirthDay.ToShortDateString());
                    EmailBody = EmailBody.Replace("[UserTelphone]", user.Telphone);
                    EmailBody = EmailBody.Replace("[UserMobile]", user.Mobile);
                    EmailBody = EmailBody.Replace("[UserQQ]", user.QQ);
                    EmailBody = EmailBody.Replace("[UserAddress]", user.Address);
                    EmailBody = EmailBody.Replace("[UserBankType]", user.BankType);
                    EmailBody = EmailBody.Replace("[UserBankName]", user.BankName);
                    EmailBody = EmailBody.Replace("[UserBankCardNumber]", user.BankCardNumber);
                    EmailBody = EmailBody.Replace("[UserisAcceptMobileMessage]", (user.isAcceptMobileMessage ? "是" : "否"));
                    EmailBody = EmailBody.Replace("[UserisAcceptEmail]", (user.isAcceptEmail ? "是" : "否"));
                    EmailBody = EmailBody.Replace("[UserisAcceptMessage]", (user.isAcceptMessage ? "是" : "否"));

                    PublicFunction.SendEmail(user.Email, EmailSubject, EmailBody);
                }
            }
            //Send MobileMessage.......................
            if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendMobileMessage", false) && (user.Mobile != "") && user.MobileValid && user.isAcceptMobileMessage && user.GetIsAcceptMobileMessage("UserEditAdv"))
            {
                string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\UserEditAdv.txt");
                if (Body != "")
                {
                    Body = Body.Replace("[UserRealityName]", user.RealityName);
                    new JL_ISP().SendMessage(user.Mobile, Body, "", user.ID);
                }
            }
            //Send Message.......................
            if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendMessage", false) && user.isAcceptMessage)
            {
                string Body = PublicFunction.GetMessageTemplate("Template\\Message\\UserEditAdv.txt");
                if (Body != "")
                {
                    Body = Body.Replace("[UserRealityName]", user.RealityName);

                    DAL.Tables.Message.Insert(1, true, user.ID, true, 1, true, ShoveEL._String.Compress(Body), true, DateTime.Now, false, true, false);
                }
            }
        }

        tbOldUserPassword.Attributes.Add("value", "");
        tbUserPassword.Attributes.Add("value", "");
        tbUserPassword2.Attributes.Add("value", "");

        ShoveEL._Web.JavaScript.Alert(this.Page, "用户普通密码修改成功。");
    }
}