﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberEdit4 : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        if (user.UserType != 2)
        {
            GoError("用户权限不足，升级为高级用户才能修改银行资料。");
            return;
        }

        if (!this.IsPostBack)
        {
            tbUserName.Text = user.Name;

            SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
            if (conn == null)
            {
                GoError();
                return;
            }

            FillBanks(conn);
            ShoveEL.ControlExt.SetDownListBoxText(ddlUserBankType, user.BankType);
            tbUserBankName.Text = user.BankName;
            tbUserBankCardNumber.Text = user.BankCardNumber;

            btnSave.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信输入的资料无误吗？") + "');");
        }

        if (user.isAlipayMember)
        {
            tbUserName.ReadOnly = true;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberEdit4.aspx";
        base.OnInit(e);
    }
    #endregion

    private void FillBanks(SqlConnection conn)
    {
        ddlUserBankType.Items.Clear();
        SqlCommand cmd = new SqlCommand("select * from Banks order by [Sort]", conn);
        SqlDataReader dr = cmd.ExecuteReader();
        while (dr.Read())
            ddlUserBankType.Items.Add(dr["Name"].ToString().Trim());
        dr.Close();
        if (ddlUserBankType.Items.Count > 0)
            ddlUserBankType.SelectedIndex = 0;
    }

    protected void btnSave_Click(object sender, System.EventArgs e)
    {
        if (tbUserBankName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入开户银行。");
            return;
        }

        if (tbUserBankCardNumber.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入银行卡号。");
            return;
        }

        /*
        if (!ShoveEL._String.Valid.isBankCardNumber(tbUserBankCardNumber.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "银行卡号格式不正确。");
            return;
        }
        */

        Users tu = new Users();
        user.Clone(tu);

        user.BankType = ddlUserBankType.SelectedItem.Text;
        user.BankName = tbUserBankName.Text.Trim();
        user.BankCardNumber = tbUserBankCardNumber.Text.Trim();

        string Return = "";
        int Result = user.EditByID(ref Return);

        if (Result != 0 || Return != "")
        {
            tu.Clone(user);
            GoError(Return);
            return;
        }

        //Send Email
        if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendEmail", false) && (user.Email != "") && user.isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\UserEditAdv.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserRealityName]", user.RealityName);

                EmailBody = EmailBody.Replace("[UserRealityName]", user.RealityName);
                EmailBody = EmailBody.Replace("[UserName]", user.Name);
                EmailBody = EmailBody.Replace("[UserPassword]", user.Password);
                EmailBody = EmailBody.Replace("[UserPassword_2]", user.Password_2);
                EmailBody = EmailBody.Replace("[UserEmail]", user.Email);
                EmailBody = EmailBody.Replace("[UserIDCardNumber]", user.IDCardNumber);
                EmailBody = EmailBody.Replace("[UserProvince]", user.Province);
                EmailBody = EmailBody.Replace("[UserCity]", user.City);
                EmailBody = EmailBody.Replace("[UserSex]", user.Sex);
                EmailBody = EmailBody.Replace("[UserBirthDay]", user.BirthDay.ToShortDateString());
                EmailBody = EmailBody.Replace("[UserTelphone]", user.Telphone);
                EmailBody = EmailBody.Replace("[UserMobile]", user.Mobile);
                EmailBody = EmailBody.Replace("[UserQQ]", user.QQ);
                EmailBody = EmailBody.Replace("[UserAddress]", user.Address);
                EmailBody = EmailBody.Replace("[UserBankType]", user.BankType);
                EmailBody = EmailBody.Replace("[UserBankName]", user.BankName);
                EmailBody = EmailBody.Replace("[UserBankCardNumber]", user.BankCardNumber);
                EmailBody = EmailBody.Replace("[UserisAcceptMobileMessage]", (user.isAcceptMobileMessage ? "是" : "否"));
                EmailBody = EmailBody.Replace("[UserisAcceptEmail]", (user.isAcceptEmail ? "是" : "否"));
                EmailBody = EmailBody.Replace("[UserisAcceptMessage]", (user.isAcceptMessage ? "是" : "否"));

                PublicFunction.SendEmail(user.Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendMobileMessage", false) && (user.Mobile != "") && user.MobileValid && user.isAcceptMobileMessage && user.GetIsAcceptMobileMessage("UserEditAdv"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\UserEditAdv.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserRealityName]", user.RealityName);
                new JL_ISP().SendMessage(user.Mobile, Body, "", user.ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendMessage", false) && user.isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\UserEditAdv.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserRealityName]", user.RealityName);

                DAL.Tables.Message.Insert(1, true, user.ID, true, 1, true, ShoveEL._String.Compress(Body), true, System.DateTime.Now, false, true, false);
            }
        }

        ShoveEL._Web.JavaScript.Alert(this.Page, "银行资料已经保存成功。");
    }
}