﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberEdit5 : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        if (user.MobileValid)
        {
            this.Response.Redirect("MemberEdit1.aspx", true);
            return;
        }

        if (user.UserType == 1)
            hlAdv.Visible = true;

        if (!this.IsPostBack)
        {
            //填充用户基本资料
            tbUserName.Text = user.Name;
            tbUserMobile.Text = user.Mobile;
        }

        if (user.isAlipayMember)
        {
            tbUserName.ReadOnly = true;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberEdit5.aspx";
        base.OnInit(e);
    }
    #endregion

    private string GetValidNumber()
    {
        int MobileCheckCharset = PublicFunction.GetOptionsAsInt("MobileCheckCharset", 1);
        int MobileCheckStringLength = PublicFunction.GetOptionsAsInt("MobileCheckStringLength", 6);

        if ((MobileCheckCharset < 1) || (MobileCheckCharset > 4))
        {
            MobileCheckCharset = 1;
        }

        if ((MobileCheckStringLength < 1) || (MobileCheckStringLength > 20))
        {
            MobileCheckStringLength = 6;
        }

        string strs;
        switch (MobileCheckCharset)
        {
            case 1:
                strs = "0123456789";
                break;
            case 2:
                strs = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            case 3:
                strs = "abcdefghijklmnopqrstuvwxyz";
                break;
            default:
                strs = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
                break;
        }

        System.Random rd = new Random();

        string str = "";
        for (int i = 0; i < MobileCheckStringLength; i++)
            str += strs[rd.Next(strs.Length - 1)].ToString();

        return str;
    }

    protected void btnMobileValid_Click(object sender, System.EventArgs e)
    {
        if (tbUserMobile.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入手机号码。");
            return;
        }

        string ValidNumber = GetValidNumber();
        ShoveEL._Web.Session.SetSession("MobileValidNumber_" + user.ID.ToString(), ValidNumber);

        //Send MobileMessage.......................
        string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\Valid.txt");
        if (Body != "")
        {
            Body = Body.Replace("[UserName]", user.Name);
            Body = Body.Replace("[ValidNumber]", ValidNumber);
        }
        else
            Body = String.Format("尊敬的{0}，您申请进行手机验证，验证字串是{1}。谢谢！" + PublicFunction.GetOptionsAsString("SiteName") + "客服中心", user.Name, ValidNumber);


        if (new JL_ISP().SendMessage(tbUserMobile.Text.Trim(), Body, "", -1) != 0)	//-1 表示系统付费
        {
            GoError("短信发送失败。");
            return;
        }

        tbUserMobile.Enabled = false;

        Label15.Visible = true;
        tbValidPassword.Visible = true;
        Label3.Visible = true;
        btnGO.Visible = true;
    }

    protected void btnGO_Click(object sender, System.EventArgs e)
    {
        string ValidNumber = ShoveEL._Web.Session.GetSessionAsString("MobileValidNumber_" + user.ID.ToString(), "LtnyeFVjxGloveshove19791130ea8g502shove");

        if (ValidNumber != tbValidPassword.Text.Trim())
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "验证串错误。");
            return;
        }

        Users temp_user = new Users();
        user.Clone(temp_user);

        user.Mobile = tbUserMobile.Text;
        user.MobileValid = true;

        string Return = "";
        int Result = user.EditByID(ref Return);

        if (Result != 0 || Return != "")
        {
            temp_user.Clone(user);
            GoError(Return);
            return;
        }

        //Send MobileMessage.......................
        string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\Valided.txt");
        if (Body != "")
        {
            Body = Body.Replace("[UserName]", user.Name);
            new JL_ISP().SendMessage(user.Mobile, Body, "", -1);
        }

        this.Response.Redirect("MemberEdit1.aspx", true);
    }
}