﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class MemberInvest : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindDataForLottery();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberInvest.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        ddlLottery.Items.Add(new ListItem("全部彩种", "-1"));
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlLottery.Items.Count > 0)
            BindDataForBuyType(ddlLottery.Items[0].Value);
    }

    private void BindDataForBuyType(string Lottery_id)
    {
        ddlBuyType.Items.Clear();
        ddlBuyType.Items.Add(new ListItem("全部玩法", "-1"));

        DataTable dt = DAL.Tables.LotteryBuyType.Select("[id],[Type]", "[Lottery_id]=" + Lottery_id, "[id]");
        if (dt == null)
            return;

        for (int i = 0; i < dt.Rows.Count; i++)
        {
            ddlBuyType.Items.Add(new ListItem(dt.Rows[i]["Type"].ToString(), dt.Rows[i]["id"].ToString()));
        }
    }

    private void BindData()
    {
        string strCmd = "select * from V_LotteryBuyDetailNonce where [User_id] = " + user.ID.ToString();
        if (ddlLottery.SelectedValue != "-1")
            strCmd += " and Lottery_id=" + ddlLottery.SelectedValue;
        if (ddlBuyType.SelectedValue != "-1")
            strCmd += " and Type_id=" + ddlBuyType.SelectedValue;

        strCmd += " order by [DateTime],[id]";

        DataTable dt = MSSQL.Select(strCmd);

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            int Scheme = ShoveEL._Convert.StrToInt(e.Item.Cells[9].Text, 0);
            e.Item.Cells[2].Text = "<a href='Scheme.aspx?id=" + Scheme.ToString() + "' target='_blank'><font color=\"#330099\">" + e.Item.Cells[4].Text + e.Item.Cells[10].Text + e.Item.Cells[11].Text + "</Font></a>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[6].Text, 0);
            e.Item.Cells[6].Text = (money == 0) ? "" : money.ToString("N");

            double Sacle = ShoveEL._Convert.StrToDouble(e.Item.Cells[7].Text, 0);
            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[12].Text, false);

            if (Quashed)
            {
                e.Item.Cells[8].Text = "<Font color=\'Blue\'>撤单</font>";
            }
            else
            {
                bool LotteryBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[13].Text, false);
                if (LotteryBuyed)
                {
                    e.Item.Cells[8].Text = "<Font color=\'Red\'>成功</font>";
                }
                else
                {
                    if (Sacle >= 100)
                    {
                        e.Item.Cells[8].Text = "<Font color=\'Red\'>满员</font>";
                    }
                    else
                    {
                        e.Item.Cells[8].Text = "未满";
                    }
                }
            }

            e.Item.Cells[7].Text += "%";
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindDataForBuyType(ddlLottery.SelectedValue);
    }

    protected void btnGo_Click(object sender, System.EventArgs e)
    {
        if (ddlLottery.SelectedIndex < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请选择彩种。");
            return;
        }

        BindData();
    }
}