﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class MemberInvestHistory : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindDataForLottery();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberInvestHistory.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlLottery.Items.Count > 0)
        {
            BindDataForIsuse(ddlLottery.Items[0].Value);
            BindDataForBuyType(ddlLottery.Items[0].Value);
        }
    }

    private void BindDataForIsuse(string Lottery_id)
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery_HistoryIsuse");

        if (dt == null)
        {
            dt = DAL.Tables.Isuse.Select("", "EndTime < GetDate()", "EndTime desc");

            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery_HistoryIsuse", dt);
        }

        DataRow[] dr = dt.Select("Lottery_id=" + Lottery_id);
        ddlIsuse.Items.Clear();
        ddlIsuse.Items.Add(new ListItem("全部", "-1"));
        for (int i = 0; i < dr.Length; i++)
            ddlIsuse.Items.Add(new ListItem(dr[i]["Isuse"].ToString(), dr[i]["id"].ToString()));
    }

    private void BindDataForBuyType(string Lottery_id)
    {
        ddlBuyType.Items.Clear();
        ddlBuyType.Items.Add(new ListItem("全部玩法", "-1"));

        DataTable dt = DAL.Tables.LotteryBuyType.Select("[id],[Type]", "[Lottery_id]=" + Lottery_id, "[id]");
        if (dt == null)
            return;

        for (int i = 0; i < dt.Rows.Count; i++)
        {
            ddlBuyType.Items.Add(new ListItem(dt.Rows[i]["Type"].ToString(), dt.Rows[i]["id"].ToString()));
        }
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindDataForIsuse(ddlLottery.SelectedValue);
        BindDataForBuyType(ddlLottery.SelectedValue);
    }

    private void BindDataInvestHistory()
    {
        string strCmd;
        if (ddlIsuse.SelectedValue == "-1")
            strCmd = "select * from V_LotteryBuyDetailWithQuashedAll where [User_id] = " + user.ID.ToString() + " and Lottery_id=" + ddlLottery.SelectedValue + " and EndTime < GetDate()";
        else
            strCmd = "select * from V_LotteryBuyDetailWithQuashedAll where [User_id] = " + user.ID.ToString() + " and Isuse_id=" + ddlIsuse.SelectedValue;

        if (ddlBuyType.SelectedValue != "-1")
            strCmd += " and Type_id=" + ddlBuyType.SelectedValue;
        strCmd += " order by [DateTime],[id]";

        DataTable dt = MSSQL.Select(strCmd);

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            int Scheme = ShoveEL._Convert.StrToInt(e.Item.Cells[12].Text, 0);
            string str = e.Item.Cells[1].Text;
            if (str.Length > 6)
                str = str.Substring(0, 5) + "..";
            e.Item.Cells[1].Text = "<a href='Scheme.aspx?id=" + Scheme.ToString() + "' target='_blank'><font color=\"#330099\">" + str + "</Font></a>";

            str = e.Item.Cells[2].Text.Trim();
            if (str.Length > 6)
                str = str.Substring(0, 5) + "..";
            e.Item.Cells[2].Text = str;

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[4].Text, 0);
            e.Item.Cells[4].Text = (money == 0) ? "" : money.ToString("N");

            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[6].Text, 0);
            e.Item.Cells[6].Text = (money == 0) ? "" : money.ToString("N");

            double i = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            double j = ShoveEL._Convert.StrToDouble(e.Item.Cells[5].Text, 0);
            if (j >= i)
                e.Item.Cells[7].Text = "100%";
            else
                if (i > 0)
                    e.Item.Cells[7].Text = Math.Round(j / i * 100, 2).ToString() + "%";

            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[8].Text, 0);
            e.Item.Cells[8].Text = (money == 0) ? "" : money.ToString("N");

            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[9].Text, 0);
            e.Item.Cells[9].Text = (money == 0) ? "" : money.ToString("N");

            bool SchemeQuashed = ShoveEL._Convert.StrToBool(e.Item.Cells[13].Text, false);
            if (SchemeQuashed)
                e.Item.Cells[11].Text = "已撤单";
            else
            {
                bool LotteryBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[14].Text, false);
                if (LotteryBuyed)
                {
                    e.Item.Cells[11].Text = "<Font color=\'Red\'>已成功</font>";
                }
                else
                {
                    int BuyedShare = ShoveEL._Convert.StrToInt(e.Item.Cells[16].Text, 0);
                    int SchemeShare = ShoveEL._Convert.StrToInt(e.Item.Cells[3].Text, 0);
                    if (BuyedShare >= SchemeShare)
                    {
                        e.Item.Cells[11].Text = "<Font color=\'Red\'>已满员</font>";
                    }
                    else
                    {
                        e.Item.Cells[11].Text = "未成功";
                    }
                }
            }
        }
    }

    protected void btnGo_Click(object sender, System.EventArgs e)
    {
        if ((ddlIsuse.SelectedIndex < 0) || (ddlIsuse.SelectedIndex >= ddlIsuse.Items.Count))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请选择彩种和期号。");
            return;
        }

        BindDataInvestHistory();
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindDataInvestHistory();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindDataInvestHistory();
    }
}