﻿using System;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;
using ShoveEL.Database;

/// <summary>
///		MemberMenu 的摘要说明。
/// </summary>
public partial class MemberMenu : System.Web.UI.UserControl
{
    public Users user;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        user = Users.GetSessionUser();
        if (user != null)
        {
            string str = user.Name;
            if (str.Length > 7)
                str = str.Substring(0, 6) + "..";
            labUserName.Text = "欢迎您!" + str;
        }
        else
            labUserName.Text = "请先登录!";

        DataTable dt = DAL.Tables.Lottery.Select("[id],[Name]", "[isUsed]=1", "[Sort]");
        if (dt == null)
        {
            PublicFunction.GoError();
            return;
        }

        DataTable dt_2 = DAL.Tables.LotteryBuyType.Select("", "", "Lottery_id, [id]");
        if (dt_2 == null)
        {
            PublicFunction.GoError();
            return;
        }

        if (!this.IsPostBack)
        {
            string Version = PublicFunction.GetVersion();

            if (Version != "1")
            {
                menuMember.Groups[2].Enabled = false;
                menuMember.Groups[3].Enabled = false;
            }

            Promotioners tp = new Promotioners();
            tp.User_id = user.ID;

            int PromotionerResult = tp.GetPromotionersInfoByUserID();

            if (!((PromotionerResult == 0) || (PromotionerResult == -4)))
            {
                if (PromotionerResult != -1)
                {
                    return;
                }
                else
                {
                    menuMember.Groups[2].Items[3].Enabled = false;
                    menuMember.Groups[2].Items[4].Enabled = false;
                    menuMember.Groups[2].Items[5].Enabled = false;
                }
            }
            else
            {
                menuMember.Groups[2].Items[3].Enabled = true;
                menuMember.Groups[2].Items[4].Enabled = true;
                menuMember.Groups[2].Items[5].Enabled = true;
            }
        }

        bool isLotteryGroupExpanded = false;

        for (int i = 0; i < dt.Rows.Count; i++)
        {
            Infragistics.WebUI.UltraWebListbar.Group NewGroup = new Infragistics.WebUI.UltraWebListbar.Group(dt.Rows[i]["Name"].ToString());
            NewGroup.GroupStyle = menuMember.Groups[0].GroupStyle;
            NewGroup.Expanded = false;

            DataRow[] dt_2_Rows = dt_2.Select("Lottery_id = " + dt.Rows[i]["id"].ToString());

            if (dt_2_Rows == null)
            {
                PublicFunction.GoError();
                return;
            }

            foreach (DataRow dr in dt_2_Rows)
            {
                string str = dr["BuyFileName"].ToString();
                if ((str == null) || (str == ""))
                    continue;

                Infragistics.WebUI.UltraWebListbar.Item NewItem = new Infragistics.WebUI.UltraWebListbar.Item();

                if (str == "Chase.aspx?id=[ID]")
                    NewItem.Text = "<font color='red'>我要追号</font>";
                else
                    NewItem.Text = dr["Type"].ToString();

                if (dr["Lottery_id"].ToString() == Lottery.ZCDC.sID)
                {
                    NewItem.TargetUrl = "MemberOfZCDC.aspx?SubPage=MemberBuy/" + str;
                    NewItem.TargetFrame = "_top";
                }
                else
                {
                    str = str.Replace("[ID]", dr["Lottery_id"].ToString()).Replace("[Lottery]", dr["Lottery_id"].ToString()).Replace("[BuyType]", dr["id"].ToString());
                    NewItem.TargetUrl = "MemberBuy/" + str;
                    NewItem.TargetFrame = "MemberIframe";
                }

                NewGroup.Items.Add(NewItem);
            }

            Infragistics.WebUI.UltraWebListbar.Item NewItem2 = new Infragistics.WebUI.UltraWebListbar.Item();
            NewItem2.Text = "玩法介绍";
            NewItem2.TargetUrl = "Explain.aspx?id=" + dt.Rows[i]["id"].ToString();
            NewItem2.TargetFrame = "_blank";
            NewGroup.Items.Add(NewItem2);

            menuMember.Groups.Add(NewGroup);

            // 是否展开此组
            if (!isLotteryGroupExpanded)
            {
                Regex regex = new Regex(@"SubPage=MemberBuy/([^?]*)[?]Lottery=(?<LotteryID>[^&]*)[&]([^\.]*).htm", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                Match m = regex.Match(this.Request.Url.AbsoluteUri);
                if (m.Success)
                {
                    int Lottery_id = ShoveEL._Convert.StrToInt(m.Groups["LotteryID"].Value.Trim(), -1);

                    if (Lottery_id.ToString() == dt.Rows[i]["id"].ToString())
                    {
                        menuMember.Groups[menuMember.Groups.Count - 1].Expanded = true;
                        isLotteryGroupExpanded = true;
                        menuMember.Groups[1].Expanded = false;
                    }
                    else
                        menuMember.Groups[menuMember.Groups.Count - 1].Expanded = false;
                }
            }
        }

        if (isLotteryGroupExpanded)
            return;

        Regex regex2 = new Regex(@"SubPage=MemberService.aspx", RegexOptions.IgnoreCase | RegexOptions.Compiled);
        Match m2 = regex2.Match(this.Request.Url.AbsoluteUri);
        if (m2.Success)
        {
            menuMember.Groups[1].Expanded = false;
            menuMember.Groups[4].Expanded = true;
            return;
        }

        regex2 = new Regex(@"SubPage=MemberEdit[\d].aspx", RegexOptions.IgnoreCase | RegexOptions.Compiled);
        m2 = regex2.Match(this.Request.Url.AbsoluteUri);
        if (m2.Success)
        {
            menuMember.Groups[1].Expanded = false;
            menuMember.Groups[0].Expanded = true;
            return;
        }

        regex2 = new Regex(@"SubPage=MemberScoringDetail.aspx", RegexOptions.IgnoreCase | RegexOptions.Compiled);
        m2 = regex2.Match(this.Request.Url.AbsoluteUri);
        if (m2.Success)
        {
            menuMember.Groups[1].Expanded = false;
            menuMember.Groups[2].Expanded = true;
            return;
        }
    }
}