﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class MemberMessage : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForSystemMessage();
            BindDataForUserMessage();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberMessage.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForSystemMessage()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("MemberMessage_System");

        if (dt == null)
        {
            dt = DAL.Views.V_Message.Select("", "[Type] = 0 and isShow = 1", "[DateTime] desc");

            if (dt == null)
            {
                GoError();
                return;
            }

            dt.Columns.Add("Content2", typeof(string));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                string Content = "";
                try
                {
                    Content = ShoveEL._String.Decompress((byte[])dt.Rows[i]["Content"]);
                }
                catch
                { }
                dt.Rows[i]["Content2"] = Content;
                dt.AcceptChanges();
            }

            ShoveEL._Web.Cache.SetCache("MemberMessage_System", dt);
        }

        g1.DataSource = dt;
        g1.DataBind();
    }

    private void BindDataForUserMessage()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("MemberMessage_User_" + user.ID.ToString());

        if (dt == null)
        {
            dt = DAL.Views.V_Message.Select("", "Type = 1 and (Aim_id = " + user.ID.ToString() + " or Aim_id = -1) and isShow = 1", "[DateTime] desc");

            if (dt == null)
            {
                GoError();
                return;
            }

            dt.Columns.Add("Content2", typeof(string));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                string Content = "";
                try
                {
                    Content = ShoveEL._String.Decompress((byte[])dt.Rows[i]["Content"]);
                }
                catch
                { }

                dt.Rows[i]["Content2"] = Content;
                dt.AcceptChanges();
            }

            ShoveEL._Web.Cache.SetCache("MemberMessage_User_" + user.ID.ToString(), dt);
        }

        g2.DataSource = dt;
        g2.DataBind();
    }

    protected void g2_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
    {
        if (e.CommandName == "Del")
        {
            int id = ShoveEL._Convert.StrToInt(e.Item.Cells[4].Text, 0);

            if (MSSQL.ExecuteNonQuery("update Message set isShow = 0 where id = " + id.ToString()) < 0)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.ClearCache("MemberMessage_User_" + user.ID.ToString());

            BindDataForUserMessage();
            return;
        }
    }
}