﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberMessageSend : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        cbSystemMessage.Enabled = (user.ManagementRights && (user.ManagementRightsList.IndexOf("[SendMessage]") >= 0));
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberMessageSend.aspx";
        base.OnInit(e);
    }
    #endregion

    protected void btnSend_Click(object sender, System.EventArgs e)
    {
        if (tbContent.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入短消息内容。");
            return;
        }

        if (cbSystemMessage.Checked)
        {
            SendSystemMessage();
            return;
        }

        if (tbAim.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入接收方用户名。");
            return;
        }

        string[] AimNames = GetAimNames(tbAim.Text.Trim());
        if (AimNames.Length < 1)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的接收方用户名。");
            return;
        }

        int CountOK = 0, CountFail = 0;	//发送计数统计
        string SendResult = "";	//发送结果

        for (int i = 0; i < AimNames.Length; i++)
        {
            if (AimNames[i] == user.Name)
            {
                CountFail++;
                SendResult += "用户 " + AimNames[i] + " 不能发送消息给自己！<BR>";
                continue;
            }

            Users temp_user = new Users();
            temp_user.Name = AimNames[i];
            int Result = temp_user.GetUserInfoByName();
            if ((Result != 0) && (Result != -3))
            {
                CountFail++;
                SendResult += "用户 " + AimNames[i] + " 不存在！<BR>";
                continue;
            }

            if (DAL.Tables.Message.Insert(user.ID, true, temp_user.ID, true, 1, true, ShoveEL._String.Compress(tbContent.Text.Trim()), true, DateTime.Now, false, true, false) < 0)
            {
                CountFail++;
                SendResult += "用户 " + AimNames[i] + " 发送错误！<BR>";
                continue;
            }

            CountOK++;
            SendResult += "用户 " + AimNames[i] + " 发送成功。<BR>";
        }

        labSendResult.Text = "发送结果：成功 " + CountOK.ToString() + " 个，失败 " + CountFail.ToString() + " 个。<BR>" + SendResult;
        if (CountFail == 0)
        {
            tbAim.Text = "";
            tbContent.Text = "";
            cbSystemMessage.Checked = false;
        }
    }

    private string[] GetAimNames(string str)
    {
        string[] strs = str.Split(',');
        ArrayList AimNames = new ArrayList();

        for (int i = 0; i < strs.Length; i++)
        {
            strs[i] = strs[i].Trim();
            if (strs[i] == "")
                continue;

            bool isExist = false;
            for (int j = 0; j < AimNames.Count; j++)
            {
                if (AimNames[j].ToString() == strs[i])
                {
                    isExist = true;
                    break;
                }
            }

            if (!isExist)
                AimNames.Add(strs[i]);
        }

        while (AimNames.Count > 10)
            AimNames.RemoveAt(AimNames.Count - 1);

        string[] Result = new string[AimNames.Count];
        for (int i = 0; i < AimNames.Count; i++)
            Result[i] = AimNames[i].ToString();

        return Result;
    }

    private void SendSystemMessage()
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            GoError();
            return;
        }

        SqlCommand Cmd = new SqlCommand("insert into Message (Source_id, Aim_id, Type, [Content]) values (@p1, -1, 0, @p2)", conn);
        Cmd.Parameters.Clear();
        Cmd.Parameters.Add("@p1", SqlDbType.Int).Value = user.ID;
        Cmd.Parameters.Add("@p2", SqlDbType.Image).Value = ShoveEL._String.Compress(tbContent.Text.Trim());
        bool Result = false;
        try
        {
            Cmd.ExecuteNonQuery();
            Result = true;
            labSendResult.Text = "系统消息发送成功。";
        }
        catch
        {
            labSendResult.Text = "系统消息发送失败。";
        }

        conn.Close();
        if (Result)
        {
            tbAim.Text = "";
            tbContent.Text = "";
            cbSystemMessage.Checked = false;
        }
    }
}