﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class MemberPromotioner : MemberPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if(!this.IsPostBack)
        {
            BindData();
        }
    }

    private void BindData()
    {
        Promotioners tp = new Promotioners();
        tp.User_id = user.ID;

        int PromotionerResult = tp.GetPromotionersInfoByUserID();

        if (!((PromotionerResult == 0) || (PromotionerResult == -4)))
        {
            GoError("用户参数错误。");
            return;
        }

        hid_id.Value = tp.Id.ToString();
        tb_bonusscale.Text = (tp.BonusScale * 100).ToString();
        tb_company.Text = tp.Company;
        tb_logourl.Text = tp.LogoUrl;
        tb_url.Text = tp.Url;
        tb_ContactPerson.Text = tp.ContactPerson;
        tb_postcode.Text = tp.PostCode;
        tb_ResponsiblePerson.Text = tp.ResponsiblePerson;
        tb_ServiceTelephone.Text = tp.ServiceTelephone;
        cb_on.Checked = tp.IsON;
        tb_Address.Text = tp.Address;
        tb_email.Text = tp.Email;
        tb_fax.Text = tp.Fax;
        tb_Mobile.Text = tp.Mobile;
        tb_Name.Text = tp.Name;
        tb_qq.Text = tp.QQ;
        tb_Telephone.Text = tp.Telephone;
        tb_Name.Text = tp.Name;
        Hid_promotioner_url.Value += PublicFunction.GetSiteUrl() + "/MemberRegister.aspx?PromotionerID=" + user.ID;
        Hid_url.Value = PublicFunction.GetSiteUrl();
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (tb_url.Text != "")
        {
            if (!ShoveEL._String.Valid.isUrl(tb_url.Text))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的网址。");
                return;
            }
        }

        if (tb_bonusscale.Text != "")
        {
            for (int i = 0; i < tb_bonusscale.Text.Length; i++)
            {
                if ("0123456789.".IndexOf(tb_bonusscale.Text.Substring(i, 1)) < 0)
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的推广佣金。");
                    return;
                }
            }
        }

        if (tb_postcode.Text != "")
        {
            for (int i = 0; i < tb_postcode.Text.Length; i++)
            {
                if ("0123456789".IndexOf(tb_postcode.Text.Substring(i, 1)) < 0)
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的邮编。");
                    return;
                }
            }
        }

        Promotioners tp = new Promotioners();
        tp.User_id = user.ID;

        tp.Url = tb_url.Text;
        tp.LogoUrl = tb_logourl.Text;
        tp.BonusScale = (ShoveEL._Convert.StrToDouble(tb_bonusscale.Text, 0) / 100);
        tp.IsON = cb_on.Checked;
        tp.Company = tb_company.Text;
        tp.Address = tb_Address.Text;
        tp.PostCode = tb_postcode.Text;
        tp.ResponsiblePerson = tb_ResponsiblePerson.Text;
        tp.ContactPerson = tb_ContactPerson.Text;
        tp.Telephone = tb_Telephone.Text;
        tp.Fax = tb_fax.Text;
        tp.Mobile = tb_Mobile.Text;
        tp.Email = tb_email.Text;
        tp.QQ = tb_qq.Text;
        tp.ServiceTelephone = tb_ServiceTelephone.Text;
        tp.Name = tb_Name.Text;

        tp.Id = int.Parse(hid_id.Value);

        string PromotionerReturn = "";
        int Promotionerresult = tp.EditByID(ref PromotionerReturn);
        if (Promotionerresult != 0 || PromotionerReturn != "")
        {
            GoError(PromotionerReturn);
            return;
        }

        if (PromotionerReturn != "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, PromotionerReturn);
        }

        ShoveEL._Web.JavaScript.Alert(this.Page, "资料已经保存成功。");
    }
}
