﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class MemberPromotionersList : MemberPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int id = -1;
            id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (id > 0)
            {
                tbID.Text = id.ToString();
            }

            BindDataForYearMonth();
            BindData();
            BindInfo();
        }
    }

    private void BindDataForYearMonth()
    {
        ddlYear.Items.Clear();
        DateTime dt = DateTime.Now;
        int Year = dt.Year;
        int Month = dt.Month;

        if (Year < 2006)
        {
            btnSearch.Enabled = false;
            return;
        }

        for (int i = 2006; i <= Year; i++)
        {
            ddlYear.Items.Add(new ListItem(i.ToString() + "年", i.ToString()));
        }

        ddlYear.SelectedIndex = ddlYear.Items.Count - 1;

        ddlMonth.SelectedIndex = Month - 1;
    }

    private void BindData()
    {

        DataTable dt = DAL.Tables.Users.Select("", "Year(RegisterTime) = " + ddlYear.SelectedValue + " and Month(RegisterTime) = " + ddlMonth.SelectedValue + " and Promotioner_id = " + user.ID.ToString(), "id desc");

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Cells[8].Text = e.Item.Cells[8].Text.Trim() == "2" ? "<font color='red'>高级</font>" : "普通";
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
        BindInfo();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
        BindInfo();
    }

    protected void btnSearch_Click(object sender, System.EventArgs e)
    {
        BindData();
        BindInfo();
    }

    protected void BindInfo()
    {
        DataTable dt = DAL.Views.V_Promotioners.Select("ClickCount,MemberCount,ConsumptionSumMoney", "User_id = " + user.ID.ToString() + " and Year(DateTime) = " + ddlYear.SelectedValue + " and Month(DateTime) = " + ddlMonth.SelectedValue, "");

        if (dt == null)
        {
            GoError();
            return;
        }

        lb_info.Text = "";

        if (dt.Rows.Count > 0)
        {
            lb_info.Text = String.Format("点击总数为：{0}， 会员总数为：{1}, 会员总购彩金额为: {2}", (dt.Rows[0][0].ToString() == "") ? "0" : dt.Rows[0][0].ToString(),
                (dt.Rows[0][1].ToString() == "") ? "0" : dt.Rows[0][1].ToString(), (dt.Rows[0][2].ToString() == "") ? "0" : double.Parse(dt.Rows[0][2].ToString()).ToString("N"));
        }

    }
}
