﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberQuestionList : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            ShoveEL._Web.Session.ClearSession("MemberQuestionList_Type");

            BindData();

            labUserName.Text = user.Name;

            int ID = ShoveEL._Convert.StrToInt(this.Request["id"], 0);
            if (ID > 0)
            {
                DataTable dt = DAL.Tables.Question.Select("", "id = " + ID.ToString(), "");

                if (dt == null)
                {
                    GoError();
                    return;
                }

                if (dt.Rows.Count > 0)
                {
                    try
                    {
                        labContent.Text = ShoveEL._Convert.ToHtmlCode(ShoveEL._String.Decompress((byte[])dt.Rows[0]["Content"]));
                    }
                    catch
                    {
                        labContent.Text = "";
                    }

                    try
                    {
                        labAnswer.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Answer"]);
                    }
                    catch
                    {
                        labAnswer.Text = "";
                    }

                    if (ShoveEL._Convert.StrToBool(dt.Rows[0]["Answered"].ToString(), false))
                    {
                        labAnswerDateTime.Text = "(答复时间：" + dt.Rows[0]["AnswerDateTime"].ToString() + ")";
                    }
                    else
                    {
                        labAnswerDateTime.Text = "(尚未答复)";
                    }
                }
            }
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberQuestionList.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        int Type = ShoveEL._Web.Session.GetSessionAsInt("MemberQuestionList_Type", 1);

        if ((Type < 1) || (Type > 3))
        {
            Type = 1;
        }

        BindData(Type);
    }

    private void BindData(int Type)
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("MemberQuestionList_" + Type.ToString());

        if (dt == null)
        {
            switch (Type)
            {
                case 1:
                    dt = DAL.Views.V_Question.Select("", "[User_id] = " + user.ID.ToString(), "[DateTime] desc");
                    break;
                case 2:
                    dt = DAL.Views.V_Question.Select("", "[User_id] = " + user.ID.ToString() + " and Answered = 0", "[DateTime] desc");
                    break;
                case 3:
                    dt = DAL.Views.V_Question.Select("", "[User_id] = " + user.ID.ToString() + " and Answered = 1", "[DateTime] desc");
                    break;
            }

            if (dt == null)
            {
                GoError();
                return;
            }

            dt.Columns.Add("Content2", System.Type.GetType("System.String"));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                string str;
                try
                {
                    str = ShoveEL._String.Decompress((byte[])dt.Rows[i]["Content"]);
                }
                catch
                {
                    str = "";
                }

                if (str.Length > 30)
                    str = str.Substring(0, 29) + "..";

                dt.Rows[i]["Content2"] = str;
                dt.AcceptChanges();
            }

            ShoveEL._Web.Cache.SetCache("MemberQuestionList_" + Type.ToString(), dt);
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void btnType_1_Click(object sender, System.EventArgs e)
    {
        int Type = ShoveEL._Convert.StrToInt(((LinkButton)sender).ID.Substring(8, 1), 1);

        ShoveEL._Web.Session.SetSession("MemberQuestionList_Type", Type);

        BindData(Type);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Cells[2].Text = "<a href='MemberQuestionList.aspx?id=" + e.Item.Cells[4].Text + "'><font color=\"#330099\">" + e.Item.Cells[2].Text + "</Font></a>";
            ((CheckBox)e.Item.Cells[3].FindControl("cbAnswered")).Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[5].Text, false);
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }
}