﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using ShoveEL.Database;

public partial class MemberRegister : System.Web.UI.Page
{
    public Users user;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        user = Users.GetSessionUser();
        if (user != null)
        {
            this.Response.Redirect("index.aspx", true);
            return;
        }

        bool RegisterAndAutoLogin = ShoveEL._Web.Session.GetSessionAsBoolean("RegisterAndAutoLogin", false);

        if ((user != null) && (RegisterAndAutoLogin))
        {
            Panel1.Visible = false;
            Panel2.Visible = false;
            Panel3.Visible = true;

            ShoveEL._Web.Session.ClearSession("RegisterAndAutoLogin");
            return;
        }

        if (user != null)
        {
            btn_1_Accept.Enabled = false;
            btn_1_NoAccept.Enabled = false;
            btn_2_Ok.Enabled = false;
            btn_3_RegisterAdv.Enabled = (user.UserType != 2);

            return;
        }

        if (!IsPostBack)
        {
            btn_1_NoAccept.Attributes.Add("onclick", "history.go(-1);return false;");
            btn_2_Ok.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信输入的资料无误，并且立即申请成为会员吗？") + "');");

            BindDataForAgreement();

            tbCommendUserID.Value = this.Request["CID"];
            tbCommendUserName.Value = System.Web.HttpUtility.UrlDecode(this.Request["CN"]);

            if ((tbCommendUserID.Value != "") && (tbCommendUserName.Value != ""))
            {
                Users CommendUser = new Users();
                //if (CommendUser.ValidUserIDAndName(conn, tbCommendUserID.Value, tbCommendUserName.Value))
                //{
                labCommendUserName.Text = tbCommendUserName.Value;
                Panel4.Visible = true;
                Panel1.Visible = false;
                Panel2.Visible = false;
                Panel3.Visible = false;
                Panel5.Visible = false;
                //}
            }

            int PromotionerUser_id = ShoveEL._Convert.StrToInt(this.Request["PromotionerID"], -1);
            int PromotionerID = -1;
            if (PromotionerUser_id > 0)
            {
                DataTable dt = DAL.Tables.Promotioners.Select("id, [ON], [Name]", "User_id = " + PromotionerUser_id.ToString(), "");

                if (dt == null || dt.Rows.Count == 0)
                {
                    PromotionerUser_id = -1;
                }
                else
                {
                    if (!ShoveEL._Convert.StrToBool(dt.Rows[0][1].ToString(), false))
                    {
                        PromotionerUser_id = -1;
                    }
                }

                tbPromotionerUser_id.Text = PromotionerUser_id.ToString();

                if (PromotionerUser_id > 0)
                {
                    Panel5.Visible = true;
                    Panel1.Visible = false;
                    Panel2.Visible = false;
                    Panel3.Visible = false;
                    Panel4.Visible = false;

                    PromotionerID = ShoveEL._Convert.StrToInt(dt.Rows[0][0].ToString(), -1);
                    tbPromotionerID.Text = PromotionerID.ToString();
                    lbPromotioner.Text = "<font color='red'>" + dt.Rows[0][2].ToString() + "</font>";
                    InsertPromotionerStatistics();
                }
                else
                {
                    Panel1.Visible = true;
                }
            }
            else
            {
                tbPromotionerUser_id.Text = PromotionerUser_id.ToString();
                tbPromotionerID.Text = PromotionerID.ToString();
            }
        }

        tb_2_UserPassword.Attributes.Add("value", tb_2_UserPassword.Text);
        tb_2_UserPassword2.Attributes.Add("value", tb_2_UserPassword2.Text);

        labAgreement.Attributes.Add("style", "height:260px; overflow:scroll");
    }

    private void BindDataForAgreement()
    {
        labAgreement.Text = PublicFunction.GetOptionsBin("Register_Agreement").Replace("[SiteName]", PublicFunction.GetOptionsAsString("SiteName")).Replace("[SiteUrl]", PublicFunction.GetOptionsAsString("SiteUrl"));
    }

    protected void btn_1_Accept_Click(object sender, System.EventArgs e)
    {
        this.Panel1.Visible = false;
        this.Panel2.Visible = true;
    }

    protected void btn_2_Ok_Click(object sender, System.EventArgs e)
    {
        if (tb_2_UserName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入用户名。");
            return;
        }

        if (tb_2_UserPassword.Text == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入用户密码。");
            return;
        }

        if (tb_2_UserPassword.Text.Length < 6)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "用户密码长度不足 6 位。");
            return;
        }

        if (tb_2_UserPassword2.Text != tb_2_UserPassword.Text)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入的两次密码不一致。");
            return;
        }

        if (tb_2_UserEmail.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入电子邮件地址。");
            return;
        }

        if (!ShoveEL._String.Valid.isEmail(tb_2_UserEmail.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "电子邮件地址格式不正确。");
            return;
        }

        System.Threading.Thread.Sleep(200);

        Users user = new Users();
        user.Name = tb_2_UserName.Text.Trim();
        if (user.GetUserInfoByName() != -1)
        {
            ShoveEL._Web.JavaScript.Alert(this, "用户名已经被使用，请重新换一个用户名！");
            return;
        }

        user.Password = tb_2_UserPassword.Text;
        user.Password_2 = user.Password;	//自动将投注密码也设为一样。
        user.Email = tb_2_UserEmail.Text.Trim();
        user.UserType = 1;
        user.Promotioner_id = ShoveEL._Convert.StrToInt(tbPromotionerUser_id.Text, -1);

        if ((tbCommendUserID.Value != "") && (tbCommendUserName.Value != ""))
        {
            Users CommendUser = new Users();
            if (CommendUser.ValidUserIDAndName(tbCommendUserID.Value, tbCommendUserName.Value))
                user.HigherUp_id = ShoveEL._Convert.StrToInt(tbCommendUserID.Value, -1);
        }

        string Return = "";
        int Result = user.Add(ref Return);
        switch (Result)
        {
            case 0:
                btn_2_Ok.Enabled = false;
                //Send Email.......................
                if (PublicFunction.GetOptionsAsBoolean("isRegisterSendEmail", false) && (user.Email != ""))
                {
                    string EmailSubject = "", EmailBody = "";
                    PublicFunction.GetEmailTemplate("Template\\Email\\Register.txt", ref EmailSubject, ref EmailBody);
                    if ((EmailSubject != "") && (EmailBody != ""))
                    {
                        EmailSubject = EmailSubject.Replace("[UserName]", user.Name);

                        EmailBody = EmailBody.Replace("[UserName]", user.Name);
                        EmailBody = EmailBody.Replace("[UserPassword]", user.Password);
                        EmailBody = EmailBody.Replace("[UserEmail]", user.Email);

                        PublicFunction.SendEmail(user.Email, EmailSubject, EmailBody);
                    }
                }

                Panel2.Visible = false;
                Panel3.Visible = true;
                break;

            case -1:
                ShoveEL._Web.JavaScript.Alert(this, "用户名刚被别人注册了，遗憾！请重新换一个用户名！");
                break;

            case -2:
                this.Response.Redirect("Error.aspx?ErrorNumber=01&Tip=" + Return, true);
                break;

            default:
                ShoveEL._Web.JavaScript.Alert(this.Page, Return);
                break;
        }

        //自动login
        bool AutoLoginOK = false;
        if (Result == 0)
        {
            if (Users.GetSessionUser() == null)
            {
                Return = "";
                bool isAliPayLogin = false;
                Result = user.Login(ref Return, isAliPayLogin);
                if (Result != 0)
                    ShoveEL._Web.JavaScript.Alert(this.Page, Return);
                else
                {
                    Users.SetSessionUser(user);
                    AutoLoginOK = true;
                }
            }
        }

        if (AutoLoginOK)
        {
            ShoveEL._Web.Session.SetSession("RegisterAndAutoLogin", true);
            //this.Response.Redirect(this.Request.Url.AbsoluteUri, true);
            this.Response.Redirect("MemberRegisterAdv.aspx", true);
        }
    }

    protected void btn_3_RegisterAdv_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("MemberRegisterAdv.aspx", true);
    }

    protected void btnAccept_Click(object sender, EventArgs e)
    {
        Panel4.Visible = false;
        Panel1.Visible = true;
    }

    protected void btnClose_Click(object sender, EventArgs e)
    {
        ShoveEL._Web.JavaScript.ClosePage(this.Page);
    }

    protected void btnAccept1_Click(object sender, EventArgs e)
    {
        Panel5.Visible = false;
        Panel1.Visible = true;
    }

    protected void btnClose1_Click(object sender, EventArgs e)
    {
        ShoveEL._Web.JavaScript.ClosePage(this.Page);
    }

    private void InsertPromotionerStatistics()
    {
        string IpAddress = this.Request.UserHostAddress;
        DateTime dt = DateTime.Now;
        int PromotionerID = int.Parse(tbPromotionerID.Text);
        bool isOK = false;

        int RowsCount = DAL.Tables.PromotionerClicks.GetCount("PromotionerID = " + PromotionerID.ToString() + " and Year([DateTime]) = " + dt.Year.ToString() + " and Month([DateTime]) = " + dt.Month.ToString() + " and Day([DateTime]) = " + dt.Day.ToString() + " and IpAddress = '" + IpAddress + "'");

        if (RowsCount < 50)
        {
            isOK = true;
        }

        if (isOK)
        {
            DAL.Tables.PromotionerClicks.Insert(PromotionerID, true, dt, true, IpAddress, true);
        }
    }
}