﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;

public partial class MemberRegisterAdv : System.Web.UI.Page
{
    public Users user;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        user = Users.GetSessionUser();

        if (user == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=02&LastRequestPage=MemberRegisterAdv.aspx", true);
            return;
        }

        bool RegisterAdvOK = ShoveEL._Web.Session.GetSessionAsBoolean("RegisterAdvOK", false);

        if (RegisterAdvOK)
        {
            Panel1.Visible = false;
            Panel2.Visible = false;
            Panel3.Visible = true;
            ShoveEL._Web.Session.ClearSession("RegisterAdvOK");

            lb_3_UserRealityName.Text = user.RealityName;
            lb_3_UserIDCardNumber.Text = user.IDCardNumber;
            lb_3_UserProvince.Text = user.Province;
            lb_3_UserCity.Text = user.City;
            //lb_3_UserPassword.Text = user.Password;	//隐藏
            //lb_3_UserPassword_2.Text = user.Password_2;	//隐藏
            lb_3_UserTelphone.Text = user.Telphone;
            lb_3_UserMobile.Text = user.Mobile;
            lb_3_UserEmail.Text = user.Email;
            lb_3_UserQQ.Text = user.QQ;
            lb_3_UserAddress.Text = user.Address;
            lb_3_UserSex.Text = user.Sex;
            lb_3_UserBirthDay.Text = user.BirthDay.ToShortDateString();
            lb_3_UserBankType.Text = user.BankType;
            lb_3_UserBankName.Text = user.BankName;
            lb_3_UserBankCardNumber.Text = user.BankCardNumber;
            lb_3_UserisAcceptMobileMessage.Text = user.isAcceptMobileMessage ? "是" : "否";
            lb_3_UserisAcceptEmail.Text = user.isAcceptEmail ? "是" : "否";
            lb_3_UserisAcceptMessage.Text = user.isAcceptMessage ? "是" : "否";

            return;
        }

        if (user.UserType == 2)	//已经是高级会员
        {
            btn_1_RegisterAdv.Enabled = false;
            btn_2_RegisterAdv.Enabled = false;
            btn_2_ReWrite.Enabled = false;
            return;
        }

        if (!this.IsPostBack)
        {
            SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
            if (conn == null)
            {
                this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
                return;
            }

            FillBanks(conn);
            FillProvince(conn);
            //FillCity(conn, ddl_1_UserProvince.Items[0].Text);

            //填充一些用户资料
            tb_1_UserRealityName.Text = user.RealityName;
            tb_1_UserIDCardNumber.Text = user.IDCardNumber;
            ShoveEL.ControlExt.SetDownListBoxText(ddl_1_UserProvince, user.Province);
            //改变省后重新填充市
            FillCity(conn, ddl_1_UserProvince.SelectedItem.Text);
            conn.Close();
            ShoveEL.ControlExt.SetDownListBoxText(ddl_1_UserCity, user.City);
            tb_1_UserTelphone.Text = user.Telphone;
            tb_1_UserMobile.Text = user.Mobile;
            tb_1_UserEmail.Text = user.Email;
            tb_1_UserQQ.Text = user.QQ;
            tb_1_UserAddress.Text = user.Address;
            if (user.Sex == "男")
                rb_1_UserSexM.Checked = true;
            else if (user.Sex == "女")
                rb_1_UserSexW.Checked = true;
            tb_1_UserBirthDay.Text = user.BirthDay.ToShortDateString();
            ShoveEL.ControlExt.SetDownListBoxText(ddl_1_UserBankType, user.BankType);
            tb_1_UserBankName.Text = user.BankName;
            tb_1_UserBankCardNumber.Text = user.BankCardNumber;
            cb_1_UserisAcceptMobileMessage.Checked = user.isAcceptMobileMessage;
            cb_1_UserisAcceptEmail.Checked = user.isAcceptEmail;
            cb_1_UserisAcceptMessage.Checked = user.isAcceptMessage;

            btn_1_RegisterAdv.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信输入的资料无误，并且立即申请成为高级会员吗？") + "');");
        }

        string MobileMessagePayType = PublicFunction.GetOptionsAsString("MobileMessagePayType", "2");
        double Price = PublicFunction.GetOptionsAsDouble("MobileMessagePrice", 0);
        if ((MobileMessagePayType == "2") && (Price > 0))
        {
            labMobileMessageCostTip.Text = " 提示：短信接收费用 " + Price.ToString("N") + " 元/条，将自动从您帐户中扣除。";
            labMobileMessageCostTip.Visible = true;
        }

        tb_1_UserPassword_2.Attributes.Add("value", tb_1_UserPassword_2.Text);
        tb_1_UserPassword_22.Attributes.Add("value", tb_1_UserPassword_22.Text);
    }

    private void FillBanks(SqlConnection conn)
    {
        ddl_1_UserBankType.Items.Clear();
        SqlCommand cmd = new SqlCommand("select * from Banks order by [Sort]", conn);
        SqlDataReader dr = cmd.ExecuteReader();
        while (dr.Read())
            ddl_1_UserBankType.Items.Add(dr["Name"].ToString().Trim());
        dr.Close();
        if (ddl_1_UserBankType.Items.Count > 0)
            ddl_1_UserBankType.SelectedIndex = 0;
    }

    private void FillProvince(SqlConnection conn)
    {
        ddl_1_UserProvince.Items.Clear();
        SqlCommand cmd = new SqlCommand("select * from Province order by [Name]", conn);
        SqlDataReader dr = cmd.ExecuteReader();
        while (dr.Read())
            ddl_1_UserProvince.Items.Add(dr["Name"].ToString().Trim());
        dr.Close();
        if (ddl_1_UserProvince.Items.Count > 0)
            ddl_1_UserProvince.SelectedIndex = 0;
    }

    private void FillCity(SqlConnection conn, string ProvinceName)
    {
        ddl_1_UserCity.Items.Clear();
        SqlCommand cmd = new SqlCommand("select * from V_City where Province=\'" + ProvinceName + "\' order by City", conn);
        SqlDataReader dr = cmd.ExecuteReader();
        while (dr.Read())
            ddl_1_UserCity.Items.Add(dr["City"].ToString().Trim());
        dr.Close();
        if (ddl_1_UserCity.Items.Count > 0)
            ddl_1_UserCity.SelectedIndex = 0;
    }

    protected void ddl_1_UserProvince_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        FillCity(conn, ddl_1_UserProvince.SelectedItem.Text);
        conn.Close();
    }

    protected void btn_1_RegisterAdv_Click(object sender, System.EventArgs e)
    {
        if (tb_1_UserRealityName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入真实姓名。");
            return;
        }

        if (tb_1_UserIDCardNumber.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入身份证号。");
            return;
        }

        if (!ShoveEL._String.Valid.isIDCardNumber(tb_1_UserIDCardNumber.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "身份证号格式不正确。");
            return;
        }

        if (tb_1_UserPassword_2.Text == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入投注密码。");
            return;
        }

        if (tb_1_UserPassword_2.Text.Length < 6)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "投注密码长度不足 6 位。");
            return;
        }

        if (tb_1_UserPassword_22.Text != tb_1_UserPassword_2.Text)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入的两次密码不一致。");
            return;
        }

        if (tb_1_UserEmail.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入电子邮件地址。");
            return;
        }

        if (!ShoveEL._String.Valid.isEmail(tb_1_UserEmail.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "电子邮件地址格式不正确。");
            return;
        }

        try
        {
            DateTime.Parse(tb_1_UserBirthDay.Text.Trim());
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的生日。");
            return;
        }

        if (tb_1_UserBankName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入开户银行。");
            return;
        }

        if (tb_1_UserBankCardNumber.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入银行卡号。");
            return;
        }

        /*
        if (!ShoveEL._String.Valid.isBankCardNumber(tb_1_UserBankCardNumber.Text.Trim()))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "银行卡号格式不正确。");
            return;
        }
        */

        Panel1.Visible = false;
        Panel2.Visible = true;

        lb_2_UserRealityName.Text = tb_1_UserRealityName.Text.Trim();
        lb_2_UserIDCardNumber.Text = tb_1_UserIDCardNumber.Text.Trim();
        lb_2_UserProvince.Text = ddl_1_UserProvince.SelectedItem.Text;
        lb_2_UserCity.Text = ddl_1_UserCity.SelectedItem.Text;
        //lb_2_UserPassword_2.Text = tb_1_UserPassword_2.Text;	//隐藏
        ShoveEL._Web.Session.SetSession("Password_2", tb_1_UserPassword_2.Text);
        lb_2_UserTelphone.Text = tb_1_UserTelphone.Text.Trim();
        lb_2_UserMobile.Text = tb_1_UserMobile.Text.Trim();
        lb_2_UserEmail.Text = tb_1_UserEmail.Text.Trim();
        lb_2_UserQQ.Text = tb_1_UserQQ.Text.Trim();
        lb_2_UserAddress.Text = tb_1_UserAddress.Text.Trim();
        lb_2_UserSex.Text = rb_1_UserSexM.Checked ? "男" : (rb_1_UserSexW.Checked ? "女" : "");
        lb_2_UserBirthDay.Text = tb_1_UserBirthDay.Text.Trim();
        lb_2_UserBankType.Text = ddl_1_UserBankType.SelectedItem.Text;
        lb_2_UserBankName.Text = tb_1_UserBankName.Text.Trim();
        lb_2_UserBankCardNumber.Text = tb_1_UserBankCardNumber.Text.Trim();
        lb_2_UserisAcceptMobileMessage.Text = cb_1_UserisAcceptMobileMessage.Checked ? "是" : "否";
        lb_2_UserisAcceptEmail.Text = cb_1_UserisAcceptEmail.Checked ? "是" : "否";
        lb_2_UserisAcceptMessage.Text = cb_1_UserisAcceptMessage.Checked ? "是" : "否";
    }

    protected void btn_2_ReWrite_Click(object sender, System.EventArgs e)
    {
        Panel2.Visible = false;
        Panel1.Visible = true;
    }

    protected void btn_2_RegisterAdv_Click(object sender, System.EventArgs e)
    {
        Users tu = new Users();
        user.Clone(tu);

        user.RealityName = lb_2_UserRealityName.Text;
        user.IDCardNumber = lb_2_UserIDCardNumber.Text;
        user.Province = lb_2_UserProvince.Text;
        user.City = lb_2_UserCity.Text;
        //user.Password_2 = lb_2_UserPassword_2.Text;
        user.Password_2 = ShoveEL._Web.Session.GetSessionAsString("Password_2", "");
        ShoveEL._Web.Session.ClearSession("Password_2");
        user.Telphone = lb_2_UserTelphone.Text;
        user.Mobile = lb_2_UserMobile.Text;
        user.Email = lb_2_UserEmail.Text;
        user.QQ = lb_2_UserQQ.Text;
        user.Address = lb_2_UserAddress.Text;
        user.Sex = lb_2_UserSex.Text;
        user.BirthDay = DateTime.Parse(lb_2_UserBirthDay.Text);
        user.BankType = lb_2_UserBankType.Text;
        user.BankName = lb_2_UserBankName.Text;
        user.BankCardNumber = lb_2_UserBankCardNumber.Text;
        user.isAcceptMobileMessage = lb_2_UserisAcceptMobileMessage.Text == "是" ? true : false;
        user.isAcceptEmail = lb_2_UserisAcceptEmail.Text == "是" ? true : false;
        user.isAcceptMessage = lb_2_UserisAcceptMessage.Text == "是" ? true : false;

        System.Threading.Thread.Sleep(200);

        user.UserType = 2;
        user.CanInvest = true;

        string Return = "";
        int result = user.EditByID(ref Return);

        if (result != 0 || Return != "")
        {
            //user.UserType = 1;
            tu.Clone(user);
            this.Response.Redirect("Error.aspx?ErrorNumber=01&Tip=" + Return, true);
            return;
        }

        //Send Email.......................
        if (PublicFunction.GetOptionsAsBoolean("isRegisterAdvSendEmail", false) && (user.Email != "") && user.isAcceptEmail)
        {
            string EmailSubject = "", EmailBody = "";
            PublicFunction.GetEmailTemplate("Template\\Email\\RegisterAdv.txt", ref EmailSubject, ref EmailBody);
            if ((EmailSubject != "") && (EmailBody != ""))
            {
                EmailSubject = EmailSubject.Replace("[UserRealityName]", user.RealityName);

                EmailBody = EmailBody.Replace("[UserRealityName]", user.RealityName);
                EmailBody = EmailBody.Replace("[UserName]", user.Name);
                EmailBody = EmailBody.Replace("[UserPassword]", user.Password);
                EmailBody = EmailBody.Replace("[UserPassword_2]", user.Password_2);
                EmailBody = EmailBody.Replace("[UserEmail]", user.Email);
                EmailBody = EmailBody.Replace("[UserIDCardNumber]", user.IDCardNumber);
                EmailBody = EmailBody.Replace("[UserProvince]", user.Province);
                EmailBody = EmailBody.Replace("[UserCity]", user.City);
                EmailBody = EmailBody.Replace("[UserSex]", user.Sex);
                EmailBody = EmailBody.Replace("[UserBirthDay]", user.BirthDay.ToShortDateString());
                EmailBody = EmailBody.Replace("[UserTelphone]", user.Telphone);
                EmailBody = EmailBody.Replace("[UserMobile]", user.Mobile);
                EmailBody = EmailBody.Replace("[UserQQ]", user.QQ);
                EmailBody = EmailBody.Replace("[UserAddress]", user.Address);
                EmailBody = EmailBody.Replace("[UserBankType]", user.BankType);
                EmailBody = EmailBody.Replace("[UserBankName]", user.BankName);
                EmailBody = EmailBody.Replace("[UserBankCardNumber]", user.BankCardNumber);
                EmailBody = EmailBody.Replace("[UserisAcceptMobileMessage]", (user.isAcceptMobileMessage ? "是" : "否"));
                EmailBody = EmailBody.Replace("[UserisAcceptEmail]", (user.isAcceptEmail ? "是" : "否"));
                EmailBody = EmailBody.Replace("[UserisAcceptMessage]", (user.isAcceptMessage ? "是" : "否"));

                PublicFunction.SendEmail(user.Email, EmailSubject, EmailBody);
            }
        }

        //Send MobileMessage.......................
        if (PublicFunction.GetOptionsAsBoolean("isRegisterAdvSendMobileMessage", false) && (user.Mobile != "") && user.MobileValid && user.isAcceptMobileMessage && user.GetIsAcceptMobileMessage("RegisterAdv"))
        {
            string Body = PublicFunction.GetMobileMessageTemplate("Template\\MobileMessage\\RegisterAdv.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserRealityName]", user.RealityName);

                new JL_ISP().SendMessage(user.Mobile, Body, "", user.ID);
            }
        }

        //Send Message.......................
        if (PublicFunction.GetOptionsAsBoolean("isRegisterAdvSendMessage", false) && user.isAcceptMessage)
        {
            string Body = PublicFunction.GetMessageTemplate("Template\\Message\\RegisterAdv.txt");
            if (Body != "")
            {
                Body = Body.Replace("[UserRealityName]", user.RealityName);

                DAL.Tables.Message.Insert(1, true, user.ID, true, 1, true, ShoveEL._String.Compress(Body), true, DateTime.Now, false, true, false);
            }
        }

        ShoveEL._Web.Session.SetSession("RegisterAdvOK", true);
        this.Response.Redirect(this.Request.Url.AbsoluteUri, true);
    }
}