﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberScoringChange : MemberPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);

        labScoringSum.Text = user.Scoring.ToString();
        labScoring.Text = ((int)(user.Scoring / 100) * 100).ToString();

        if (user.Scoring < 10)
        {
            tbScoring.Enabled = false;
            btnGo.Enabled = false;
        }

        if (!this.IsPostBack)
            btnGo.Attributes.Add("onclick", "return btnGoClick();");
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberScoringChange.aspx";
        base.OnInit(e);
    }
    #endregion

    protected void btnGo_Click(object sender, System.EventArgs e)
    {
        string Return = "";
        user.GetUserBalance(ref Return);
        labScoringSum.Text = user.Scoring.ToString();
        labScoring.Text = ((int)(user.Scoring / 100) * 100).ToString();

        int Scoring = ShoveEL._Convert.StrToInt(tbScoring.Text, 0);
        if ((Scoring < 100) || (Scoring > user.Scoring) || ((int)(Scoring / 100) * 100 != Scoring))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的兑换积分。");
            return;
        }

        Return = "";
        int Result = user.ScoringChange(Scoring, ref Return);
        if ((Return != "") || (Result != 0))
        {
            GoError(Return);
            return;
        }

        labScoringSum.Text = user.Scoring.ToString();
        labScoring.Text = ((int)(user.Scoring / 100) * 100).ToString();
        tbScoring.Text = "";
        ShoveEL._Web.JavaScript.Alert(this.Page, "积分兑换成功，兑换金额已经存到您的可用资金中。");
    }
}