﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class MemberService : MemberPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        labUserName.Text = user.Name;
        if (!this.IsPostBack)
        {
            FillQuestionType();
            tbUserTelphone.Text = user.Telphone;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "MemberService.aspx";
        base.OnInit(e);
    }
    #endregion

    private void FillQuestionType()
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            GoError();
            return;
        }

        SqlCommand Cmd = new SqlCommand("select * from QuestionType order by id", conn);
        SqlDataReader dr = null;

        try
        {
            dr = Cmd.ExecuteReader();
        }
        catch
        {
            conn.Close();
            GoError();
            return;
        }

        while (dr.Read())
            ddlQuestionType.Items.Add(dr["Type"].ToString());

        dr.Close();
        conn.Close();
    }

    protected void btnSave_Click(object sender, System.EventArgs e)
    {
        if (tbUserTelphone.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入联系电话。");
            return;
        }

        if (tbContent.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入问题描述。");
            return;
        }

        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            GoError();
            return;
        }

        SqlCommand Cmd = new SqlCommand("insert into Question (User_id, Type_id, Telphone, [Content]) values (@p1, @p2, @p3, @p4)", conn);
        Cmd.Parameters.Add("@p1", SqlDbType.Int).Value = user.ID;
        Cmd.Parameters.Add("@p2", SqlDbType.Int).Value = ddlQuestionType.SelectedIndex + 1;
        Cmd.Parameters.Add("@p3", SqlDbType.VarChar).Value = tbUserTelphone.Text.Trim();
        Cmd.Parameters.Add("@p4", SqlDbType.Image).Value = ShoveEL._String.Compress(tbContent.Text.Trim());
        try
        {
            Cmd.ExecuteNonQuery();
        }
        catch
        {
            conn.Close();
            GoError();
            return;
        }

        conn.Close();
        tbContent.Text = "";
        ShoveEL._Web.JavaScript.Alert(this.Page, "问题提交成功。");
    }
}