﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Security.Cryptography;

public partial class MemberSharing_Alipay_Login : System.Web.UI.Page
{
    public Users user;    

    protected void Page_Load(object sender, EventArgs e)
    {
        user = Users.GetSessionUser();

        if (user != null)
        {
            Response.Write("<script language=\"javascript\">window.parent.location.href=\"" + PublicFunction.GetSiteUrl() + "/Index.aspx\";</script>");
            return;
        }

        bool MemberSharing_Alipay_Status_ON = PublicFunction.GetOptionsAsBoolean("MemberSharing_Alipay_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetMID() + PublicFunction.GetOptionsAsString("MemberSharing_Alipay_Maturity"), PublicFunction.GetOptionsAsString("MemberSharing_Alipay_ON_Cert"), "SLMSC");

        if (!MemberSharing_Alipay_Status_ON)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "尚未启用此项功能或者此项功能的服务已经过期！", PublicFunction.GetSiteUrl() + "/Index.aspx");
            return;
        }

        Button btnAliPayLogin = new Button();

        btnAliPayLogin.ID = "btnAliPayLogin";
        btnAliPayLogin.Click += new System.EventHandler(this.btnAliPayLogin_Click);

        btnAliPayLogin_Click(btnAliPayLogin, new EventArgs());
    }

    protected void btnAliPayLogin_Click(object sender, EventArgs e)
    {
        string Gateway = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_Gateway") + "?";             //支付接口
        string Partner = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_UserNumber");          //卖家商户号
        string Key = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_MD5");
        string ReturnUrl = PublicFunction.GetSiteUrl() + "/MemberSharing/Alipay/LoginReceive.aspx";     //服务器通知返回接口
        string InputCharset = "utf-8";
        string SignType = "MD5";

        //客户私有参数
        string parameters = HttpUtility.UrlEncode(ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()));

        string RequestUrl = CreatUrl(Gateway, Partner, SignType, ReturnUrl, Key, InputCharset, parameters);

        Response.Redirect(RequestUrl, true);
        //this.Response.Write("<script language='javascript'>window.top.location.href='" + RequestUrl + "'</script>");
    }

    private string[] BubbleSort(string[] r)
    {
        /// <summary>
        /// 冒泡排序法
        /// </summary>

        int i, j; //交换标志 
        string temp;

        bool exchange;

        for (i = 0; i < r.Length; i++) //最多做R.Length-1趟排序 
        {
            exchange = false; //本趟排序开始前，交换标志应为假

            for (j = r.Length - 2; j >= i; j--)
            {
                if (System.String.CompareOrdinal(r[j + 1], r[j]) < 0)　//交换条件
                {
                    temp = r[j + 1];
                    r[j + 1] = r[j];
                    r[j] = temp;

                    exchange = true; //发生了交换，故将交换标志置为真 
                }
            }

            if (!exchange) //本趟排序未发生交换，提前终止算法 
            {
                break;
            }

        }
        return r;
    }

    private string GetMD5(string s, string _input_charset)
    {
        /// <summary>
        /// 与ASP兼容的MD5加密算法
        /// </summary>

        MD5 md5 = new MD5CryptoServiceProvider();
        byte[] t = md5.ComputeHash(Encoding.GetEncoding(_input_charset).GetBytes(s));
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < t.Length; i++)
        {
            sb.Append(t[i].ToString("x").PadLeft(2, '0'));
        }
        return sb.ToString();
    }

    private string CreatUrl(
        string Gateway,
        string Partner,
        string SignType,
        string ReturnUrl,
        string Key,
        string InputCharset,
        string parameters
    )
    {
        /// <summary>
        /// created by sunzhizhi 2006.5.21,sunzhizhi@msn.com。
        /// </summary>
        int i;

        //构造数组；
        string[] Oristr ={ 
                "Partner=" + Partner, 
                "InputCharset=" + InputCharset,          
                "ReturnUrl=" + ReturnUrl,
                "parameters=" + parameters
                };

        //进行排序；
        string[] Sortedstr = BubbleSort(Oristr);

        //构造待md5摘要字符串 ；

        StringBuilder prestr = new StringBuilder();

        for (i = 0; i < Sortedstr.Length; i++)
        {
            if (i == Sortedstr.Length - 1)
            {
                prestr.Append(Sortedstr[i]);

            }
            else
            {
                prestr.Append(Sortedstr[i] + "&");
            }
        }

        prestr.Append(Partner + Key);

        //生成Md5摘要；
        string Sign = GetMD5(prestr.ToString(), InputCharset);

        //构造支付Url；
        char[] delimiterChars = { '=' };
        StringBuilder parameter = new StringBuilder();
        parameter.Append(Gateway);
        for (i = 0; i < Sortedstr.Length; i++)
        {
            parameter.Append(Sortedstr[i].Split(delimiterChars)[0] + "=" + HttpUtility.UrlEncode(Sortedstr[i].Split(delimiterChars)[1]) + "&");
        }

        parameter.Append("Sign=" + Sign + "&SignType=" + SignType);

        //返回支付Url；
        return parameter.ToString();
    }
}
