﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using System.Web.Security;
using System.Text;
using System.Security.Cryptography;
using System.Collections.Specialized;
using System.IO;
using System.Data.SqlClient;
using System.Data.OleDb;
using System.Net;

using Gateway;

public partial class MemberSharing_Alipay_LoginReceive : System.Web.UI.Page
{
    public Users user;

    //获取远程服务器ATN结果
    public String Get_Http(String a_strUrl, int timeout)
    {
        string strResult;
        try
        {

            HttpWebRequest myReq = (HttpWebRequest)HttpWebRequest.Create(a_strUrl);
            myReq.Timeout = timeout;
            HttpWebResponse HttpWResp = (HttpWebResponse)myReq.GetResponse();
            Stream myStream = HttpWResp.GetResponseStream();
            StreamReader sr = new StreamReader(myStream, Encoding.Default);
            StringBuilder strBuilder = new StringBuilder();
            while (-1 != sr.Peek())
            {
                strBuilder.Append(sr.ReadLine());
            }

            strResult = strBuilder.ToString();
        }
        catch (Exception exp)
        {

            strResult = "错误：" + exp.Message;
        }

        return strResult;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        user = Users.GetSessionUser();

        if (user != null)
        {
            Response.Write("<script language=\"javascript\">window.parent.location.href=\"" + PublicFunction.GetSiteUrl() + "/Index.aspx\";</script>");
            return;
        }

        bool MemberSharing_Alipay_Status_ON = PublicFunction.GetOptionsAsBoolean("MemberSharing_Alipay_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetMID() + PublicFunction.GetOptionsAsString("MemberSharing_Alipay_Maturity"), PublicFunction.GetOptionsAsString("MemberSharing_Alipay_ON_Cert"), "SLMSC");

        if (!MemberSharing_Alipay_Status_ON)
        {
            this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx?ErrorNumber=01&Tip=尚未启用此项功能或者此项功能的服务已经过期！", true);
            //ShoveEL._Web.JavaScript.Alert(this.Page, "尚未启用此项功能或者此项功能的服务已经过期！", PublicFunction.GetSiteUrl() + "/Index.aspx");

            return;
        }

        //*************************************************************************
        string alipayNotifyURL = "http://notify.alipay.com/trade/notify_query.do?";
        string key = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_MD5"); //partner 的对应交易安全校验码（必须填写）和alipay.cs文件中值是一样的
        string _input_charset = "utf-8";
        string partner = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_UserNumber");  //卖家商户号
        //*************************************************************************

        string TmpKey = Request["key"];     //校验本次登录是否有效
        string parameters = Request["parameters"];

        alipayNotifyURL = alipayNotifyURL + "partner=" + partner + "&notify_id=" + Request.QueryString["notify_id"];

        //获取支付宝ATN返回结果，true是正确的订单信息，false 是无效的
        //string responseTxt = Get_Http(alipayNotifyURL, 120000);

        int i;
        NameValueCollection coll;
        //Load Form variables into NameValueCollection variable.
        coll = Request.QueryString;

        // Get names of all forms into a string array.
        String[] requestarr = coll.AllKeys;

        //进行排序；
        string[] Sortedstr = AliPay.BubbleSort(requestarr);

        //构造待md5摘要字符串 ；
        StringBuilder prestr = new StringBuilder();

        for (i = 0; i < Sortedstr.Length; i++)
        {
            //if (Request.Form[Sortedstr[i]] != "" && Sortedstr[i] != "sign" && Sortedstr[i] != "sign_type")
            if (Sortedstr[i] != "sign" && Sortedstr[i] != "sign_type")
            {
                if (i == Sortedstr.Length - 1)
                {
                    prestr.Append(Sortedstr[i] + "=" + Request.QueryString[Sortedstr[i]]);

                }
                else
                {
                    prestr.Append(Sortedstr[i] + "=" + Request.QueryString[Sortedstr[i]] + "&");
                }
            }
        }

        prestr.Append(partner + key);

        //生成Md5摘要；
        string mysign = AliPay.GetMD5(prestr.ToString(), _input_charset);

        string sign = Request.QueryString["sign"];
        string Success = Request.QueryString["is_success"].ToString().ToUpper();
        string Email = Request.QueryString["email"];                    //获得用户EMail
        string RealityName = Request.QueryString["real_name"];          //获得用户名
        string IDCardNumber = Request.QueryString["cert_no"];           //获得证件号码
        string Sex = Request.QueryString["gender"];                     //获得用户性别
        //string Province = Request.QueryString["province"];            //获得用户所在省份
        string City = Request.QueryString["city"];                      //获得用户所在城市
        string Address = Request.QueryString["address"];                //获得用户所在地址
        string Telephone = Request.QueryString["phone"];                //获得用户电话号码
        string Mobile = Request.QueryString["mobile"];                  //获得用户手机号码
        string Is_Mobile_Auth = Request.QueryString["Is_Mobile_Auth"];  //手机是否通过校验
        //******************************************************************************

        //int UID = -1;
        DateTime Key = DateTime.Now.AddYears(-20);
        bool AllowLogin = false;

        try
        {
            //UID = ShoveEL._Convert.StrToLong(this.Request["user_id"], -1);
            Key = DateTime.Parse(ShoveEL._Security.Encrypt.UnEncryptString(parameters));
        }
        catch
        {
        }

       
        TimeSpan ts = DateTime.Now - Key;

        //if ((UID >= 0) && (Math.Abs(ts.TotalSeconds) < 60))
        if (Math.Abs(ts.TotalSeconds) < 300)
        {
            AllowLogin = true;
        }

        if (!AllowLogin)
        {
            this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx?ErrorNumber=01&Tip=登陆超时，无法登录网站。请重新登陆！", true);

            return;
        }

         //if ((mysign == sign) && (responseTxt == "true"))   //验证支付发过来的消息，签名是否正确（防止有伪造消息）
        if (mysign == sign)
        {
            user = new Users();

            if (Success == "T")
            {
                user.Name = Email;

                string Return = "";
                bool isAliPayLogin = true;

                DataTable dt = DAL.Tables.Users.Select("", "[Name]='" + Email + "' and isAlipayMember = 1", "");
                if (dt == null)
                {
                    //ShoveEL._Web.JavaScript.Alert(this.Page, "读数据出错！", PublicFunction.GetSiteUrl() + "/index.aspx");
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx?ErrorNumber=01&Tip=读数据出错！", true);

                    return;
                }

                if (dt.Rows.Count == 0)
                {
                    user.Email = Email;
                    user.Password = sign + IDCardNumber;
                    user.Password_2 = sign + IDCardNumber;
                    user.RealityName = (RealityName == "无" ? "" : RealityName);
                    user.IDCardNumber = (IDCardNumber == null ? "" : IDCardNumber);
                    user.Sex = (Sex == "m") ? "男" : (Sex == "w" ? "女" : "未知");
                    user.Address = Address;
                    user.City = City;
                    user.Telphone = Telephone;
                    user.Mobile = Mobile;
                    user.MobileValid = ((Mobile.Trim() != "") && (Is_Mobile_Auth.Trim().ToLower() == "t"));
                    user.UserType = 2;
                    user.isAlipayMember = true;

                    int Result1 = user.Add(ref Return);
                    switch (Result1)
                    {
                        case 0:
                            //Send Email.......................
                            if (PublicFunction.GetOptionsAsBoolean("isRegisterSendEmail", false) && (user.Email != ""))
                            {
                                string EmailSubject = "", EmailBody = "";
                                PublicFunction.GetEmailTemplate("Template\\Email\\Register.txt", ref EmailSubject, ref EmailBody);
                                if ((EmailSubject != "") && (EmailBody != ""))
                                {
                                    EmailSubject = EmailSubject.Replace("[UserName]", user.Name);

                                    EmailBody = EmailBody.Replace("[UserName]", user.Name);
                                    EmailBody = EmailBody.Replace("[UserPassword]", user.Password);
                                    EmailBody = EmailBody.Replace("[UserEmail]", user.Email);

                                    PublicFunction.SendEmail(user.Email, EmailSubject, EmailBody);
                                }
                            }

                            break;
                    }

                    //自动login
                    if (Result1 == 0)
                    {
                        if (Users.GetSessionUser() == null)
                        {
                            Return = "";
                            int Result2 = user.Login(ref Return, isAliPayLogin);
                            if (Result2 != 0)
                            {
                                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx?ErrorNumber=01&Tip=" + Return.ToString(), true);

                                return;
                            }
                            else
                            {
                                Users.SetSessionUser(user);

                                this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Index.aspx';</script>");

                                return;
                            }
                        }
                    }
                    else
                    {
                        switch (Result1)
                        {
                            case -1:
                                Return = "用户名刚被别人注册了，遗憾！请重新换一个用户名！";

                                break;

                            default:
                                Return = Return.ToString();

                                break;
                        }

                        string url = PublicFunction.GetSiteUrl() + "/MemberRegister.aspx";
                        //ShoveEL._Web.JavaScript.Alert(this.Page, Return.ToString(), url);
                        this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx?ErrorNumber=01&Tip=" + Return.ToString(), true);

                        return;
                    }
                }
                else
                {
                    int Result2 = user.Login(ref Return, isAliPayLogin);
                    if (Result2 != 0)
                    {
                        this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx?ErrorNumber=01&Tip=" + Return.ToString(), true);

                        return;
                    }
                    else
                    {
                        Users.SetSessionUser(user);

                        this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Index.aspx';</script>");

                        return;
                    }

                }
            }
            else
            {
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx?ErrorNumber=01&Tip=您不是有效的支付宝会员不能登录本站，请您注册成为本站会员，再登录，谢谢", true);

                return;
            }
        }
        else
        {
            this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx?ErrorNumber=01&Tip=本站尚未启用支付宝会员共享功能，请您注册成为本站会员，再登录，谢谢", true);

            return;
        }
    }
}
