﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class MenmberPromotionerAccount : MemberPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            tbTimeFrom.Text = System.DateTime.Now.ToShortDateString();
            tbTimeTo.Text = System.DateTime.Now.ToShortDateString();

            BindData();
        }
    }

    private void BindData()
    {

        Users tu = new Users();
        tu.ID = user.ID;
        int Result = tu.GetUserInfoByID();
        if (!((Result == 0) || (Result == -3) || (Result == -4)))
        {
            GoError("用户参数错误。");
            return;
        }

        BindData(tu);
    }

    private void BindData(Users tu)
    {
        System.DateTime TimeFrom, TimeTo;
        try
        {
            TimeFrom = System.DateTime.Parse(tbTimeFrom.Text.Trim());
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "开始时间格式输入错误！");
            return;
        }
        try
        {
            TimeTo = System.DateTime.Parse(tbTimeTo.Text.Trim());
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "结束时间格式输入错误！");
            return;
        }
        TimeFrom = DateTime.Parse(TimeFrom.ToShortDateString() + " 0:0:0");
        TimeTo = DateTime.Parse(TimeTo.ToShortDateString() + " 23:59:59");
        if (TimeFrom > TimeTo)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "结束时间应该在开始时间之后！");
            return;
        }


        DataSet ds = DAL.Procedures.P_GetMemberPromotionerDetail.Open(tu.ID, TimeFrom, TimeTo);
        if ((ds == null) || (ds.Tables.Count < 1))
        {
            GoError();
            return;
        }

        g.DataSource = ds.Tables[0];
        g.DataBind();
        gPager.Visible = (ds.Tables[0].Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            e.Item.Cells[2].Text = (money == 0) ? "" : money.ToString("N");
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[3].Text, 0);
            e.Item.Cells[3].Text = (money == 0) ? "" : money.ToString("N");

            int Scheme = ShoveEL._Convert.StrToInt(e.Item.Cells[4].Text, 0);
            if (Scheme > 0)
                e.Item.Cells[1].Text = "<a href='Scheme.aspx?id=" + Scheme.ToString() + "' target='_blank'><font color=\"#330099\">" + e.Item.Cells[1].Text + "</Font></a>";
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }
    protected void btnGO_Click(object sender, EventArgs e)
    {
        BindData();
    }
}
