﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class NewsFootball05 : System.Web.UI.Page
{
    public string[] NewEditTitle = new string[2];
    public int[] NewEditID = new int[2];

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    private void BindData()
    {
        NewEditTitle[0] = ""; NewEditTitle[1] = "";
        NewEditID[0] = 0; NewEditID[1] = 0;

        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        SqlDataAdapter da = new SqlDataAdapter("select * from NewsFootball05 where isShow=1 order by [DateTime] desc", conn);
        DataTable dt = new DataTable();
        da.Fill(dt);

        for (int i = 0; i < dt.Rows.Count; i++)
        {
            int MaxLen = 34;
            if (dt.Rows[i]["Image"].ToString().Trim() != "")
                MaxLen = 32;
            string title = dt.Rows[i]["Title"].ToString();
            if (title.Length > MaxLen)
                title = title.Substring(0, MaxLen) + "...";
            if (dt.Rows[i]["Image"].ToString().Trim() != "")
                title += "(图)";
            dt.Rows[i]["Title"] = title;
            dt.AcceptChanges();

            if (i < 2)
            {
                NewEditTitle[i] = title;
                NewEditID[i] = ShoveEL._Convert.StrToInt(dt.Rows[i]["ID"].ToString(), 0);
            }
        }

        this.g.DataSource = dt.DefaultView;
        g.DataBind();

        conn.Close();
    }

    protected void g_PageIndexChanged(object sender, System.EventArgs e)
    {
        g.CurrentPageIndex = ((DataGridPageChangedEventArgs)e).NewPageIndex;
        BindData();
    }
}