﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class OnlinePay_99Bill_Receive : System.Web.UI.Page
{
    private string merchant_id = "";
    private string orderid = "";
    private string amount = "";
    private string date = "";
    private string succeed = "";
    private string mac = "";
    private string merchant_param = "";
    private string merchant_param_UnEncrypt = "";

    private string couponid = "";
    private string couponvalue = "";

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_99Bill_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_99Bill_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_99Bill_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_99Bill_ON_Cert"), "SPAYC");
        if (!OnlinePay_99Bill_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }

        if (!this.IsPostBack)
        {
            try
            {
                merchant_id = Request["merchant_id"].ToString();		// 获取商户编号
                orderid = Request["orderid"].ToString();		        // 获取订单编号
                amount = Request["amount"].ToString();		            // 获取订单金额
                date = Request["date"].ToString();	        	        // 获取交易日期
                succeed = Request["succeed"].ToString();		        // 获取交易结果,Y成功,N失败
                mac = Request["mac"].ToString();		                // 获取安全加密串
                merchant_param = Request["merchant_param"].ToString();	// 获取商户私有参数，存放的充值的用户ID
                merchant_param_UnEncrypt = ShoveEL._Security.Encrypt.UnEncryptString(merchant_param);
            }
            catch
            {
                this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                //this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx" ,true);
                return;
            }

            if (merchant_id != PublicFunction.GetOptionsAsString("OnlinePay_99Bill_UserNumber"))
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            Users user = Users.GetSessionUser();

            if (user == null)
            {
                user = new Users();
                user.ID = ShoveEL._Convert.StrToInt(merchant_param_UnEncrypt, -1);

                if (user.ID < 0)
                {
                    this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                    //this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }

                int Result = user.GetUserInfoByID();
                if ((Result != 0) && (Result != -3))
                {
                    this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                    //this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }
            }

            if (user.ID != ShoveEL._Convert.StrToInt(merchant_param_UnEncrypt, -1))
            {
                this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                //this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            //couponid = Request["couponid"].ToString();	    	// 获取优惠券编码
            //couponvalue = Request["couponvalue"].ToString();		// 获取优惠券面额

            // 生成加密串,注意顺序
            string SrctStr = "merchant_id=" + merchant_id + "&orderid=" + orderid + "&amount=" + amount + "&date=" + date + "&succeed=" + succeed + "&merchant_key=" + PublicFunction.GetOptionsAsString("OnlinePay_99Bill_MD5");
            string mymac = System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(SrctStr, "MD5");

            if ((mac == mymac) && (succeed == "Y"))
            {
                WriteUserAccount(user, orderid, amount);
                this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + merchant_param + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx'</script>");
                //this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + merchant_param + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx", true);
                return;
            }
            else
            {
                this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + merchant_param + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx'</script>");
                //this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + merchant_param + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx", true);
                return;
            }
        }
    }

    private bool WriteUserAccount(Users user, string orderid, string amount)
    {
        double Money = ShoveEL._Convert.StrToDouble(amount, 0);
        if (Money == 0)
            return false;

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_99Bill_CommissionScale", 0) / 100;
        double Commission = Money - Math.Round(Money / (CommissionScale + 1), 2);
        Money -= Commission;

        string Return = "";
        bool ok = (user.AddUserBalance_1(Money, Commission, orderid, "快钱支付", "", "", ref Return) == 0);

        return ok;
    }
}