﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;

public partial class OnlinePay_99Bill_Send : MemberPage
{
    protected string merchant_id;
    protected string orderid;
    protected string amount;
    protected string merchant_url;
    protected string pname;
    protected string commdity_info;
    protected string pemail;
    protected string merchant_param;
    protected string mac;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_99Bill_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_99Bill_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_99Bill_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_99Bill_ON_Cert"), "SPAYC");
        if (!OnlinePay_99Bill_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "OnlinePay/99Bill/Send.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindInfo()
    {
        merchant_id = PublicFunction.GetOptionsAsString("OnlinePay_99Bill_UserNumber");
        merchant_url = PublicFunction.GetSiteUrl() + "/OnlinePay/99Bill/Receive.aspx";
        pname = user.Name;              //System.Web.HttpUtility.UrlEncode(user.Name);
        commdity_info = "预付款";       //System.Web.HttpUtility.UrlEncode("预付款");
        pemail = user.Email;
        merchant_param = ShoveEL._Security.Encrypt.EncryptString(user.ID.ToString());            //私有参数,放的充值的用户ID

        pid.Value = "889907040253358350";           //代理商编号

        double PayMoney = Convert.ToDouble(this.PayMoney.Text.Trim());
        amount = PayMoney.ToString();

        long PayNumber = 0;
        string Return = "";

        if (DAL.Procedures.P_GetNewPayNumber.Call(user.ID, "99Bill", PayMoney, ref PayNumber, ref Return) < 0)
        {
            GoError("数据读取错误。");
            return;
        }
        if ((PayNumber < 0) || (Return != ""))
        {
            GoError(Return);
            return;
        }

        orderid = PayNumber.ToString();

        String ScrtStr = "merchant_id=" + merchant_id + "&orderid=" + orderid + "&amount=" + amount + "&merchant_url=" + merchant_url + "&merchant_key=" + PublicFunction.GetOptionsAsString("OnlinePay_99Bill_MD5");
        mac = System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(ScrtStr, "MD5");
    }

    protected void OnlinePayed_Click(object sender, System.EventArgs e)
    {
        double money = 0;

        if (user.SuperManagementRights)
        {
            money = ShoveEL._Convert.StrToDouble(this.PayMoney.Text.Trim(), 0);
            if (money < 0.01)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }
        else
        {
            money = ShoveEL._Convert.StrToInt(this.PayMoney.Text.Trim(), 0);
            if (money < 1)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_99Bill_CommissionScale", 0) / 100;
        double Commission = Math.Round(money * CommissionScale, 2);

        money += Commission;
        this.PayMoney.Text = money.ToString();
        labCommission.Text = "手续费 " + Commission.ToString() + " 元由支付网关提供商收取。";

        this.PayMoney.Enabled = false;
        OnlinePayed.Enabled = false;

        BindInfo();

        this.Panel1.Visible = true;
    }
}