﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Security.Cryptography;
using System.Collections.Specialized;
using System.IO;
using System.Data.SqlClient;
using System.Net;

using Gateway;

//本页不做任何数据处理
public partial class OnlinePay_Alipay_Notify : System.Web.UI.Page
{
    //获取远程服务器ATN结果
    public String Get_Http(String a_strUrl, int timeout)
    {
        string strResult;
        try
        {
            HttpWebRequest myReq = (HttpWebRequest)HttpWebRequest.Create(a_strUrl);
            myReq.Timeout = timeout;
            HttpWebResponse HttpWResp = (HttpWebResponse)myReq.GetResponse();
            Stream myStream = HttpWResp.GetResponseStream();
            StreamReader sr = new StreamReader(myStream, Encoding.Default);
            StringBuilder strBuilder = new StringBuilder();
            while (-1 != sr.Peek())
            {
                strBuilder.Append(sr.ReadLine());
            }

            strResult = strBuilder.ToString();
        }
        catch (Exception exp)
        {

            strResult = "错误：" + exp.Message;
        }

        return strResult;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        bool OnlinePay_Alipay_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_Alipay_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_Alipay_UserName"), PublicFunction.GetOptionsAsString("OnlinePay_Alipay_ON_Cert"), "SPAYC");
        if (!OnlinePay_Alipay_Status_ON)
        {
            Response.Write("fail");     //暂未开通
            return;
        }

        //***************************************************************     
        string key = PublicFunction.GetOptionsAsString("OnlinePay_Alipay_MD5");             //MD5-Key 
        string _input_charset = "utf-8";
        string partner = PublicFunction.GetOptionsAsString("OnlinePay_Alipay_UserNumber");  //卖家商户号

        //string alipayNotifyURL = "https://www.alipay.com/cooperate/gateway.do?";	        //支付接口
        //alipayNotifyURL = alipayNotifyURL + "service=notify_verify" + "&partner=" + partner + "&notify_id=" + Request.Form["notify_id"];
        String alipayNotifyURL = "http://notify.alipay.com/trade/notify_query.do?";
        alipayNotifyURL = alipayNotifyURL + "partner=" + partner + "&notify_id=" + Request.Form["notify_id"];

        //获取支付宝ATN返回结果，true是正确的订单信息，false 是无效的
        string responseTxt = Get_Http(alipayNotifyURL, 120000);
        int i;
        NameValueCollection coll;
        //Load Form variables into NameValueCollection variable.
        coll = Request.Form;

        // Get names of all forms into a string array.
        String[] requestarr = coll.AllKeys;

        //进行排序；
        string[] Sortedstr = AliPay.BubbleSort(requestarr);

        //构造待md5摘要字符串 ；

        StringBuilder prestr = new StringBuilder();

        for (i = 0; i < Sortedstr.Length; i++)
        {
            if (Request.Form[Sortedstr[i]] != "" && Sortedstr[i] != "sign" && Sortedstr[i] != "sign_type")
            {
                if (i == Sortedstr.Length - 1)
                {
                    prestr.Append(Sortedstr[i] + "=" + Request.Form[Sortedstr[i]]);
                }
                else
                {
                    prestr.Append(Sortedstr[i] + "=" + Request.Form[Sortedstr[i]] + "&");

                }
            }
        }

        prestr.Append(key);
        string mysign = AliPay.GetMD5(prestr.ToString(), _input_charset);
        string sign = Request.Form["sign"];
        string trade_status = Request.Form["trade_status"];
        string trade_no = Request.Form["trade_no"];              //支付宝交易号
        string out_trade_no = Request.Form["out_trade_no"];      //自己交易号
        //string payment_type = Request.Form["payment_type"];      //支付类型
        string subject = Request.Form["subject"];                //商品名称，用户存放用户ID
        string subject_UnEncrypt = ShoveEL._Security.Encrypt.UnEncryptString(subject);
        double total_fee = double.Parse(Request.Form["total_fee"].ToString());       //支付金额
        string seller_email = Request.Form["seller_email"];      //卖家账号

        if (seller_email != PublicFunction.GetOptionsAsString("OnlinePay_Alipay_UserName"))
        {
            PublicFunction.WriteLog("校验用户信息出错!(Notify)");
            Response.Write("fail");
            return;
        }

        if (mysign == sign && responseTxt == "true" && trade_status == "TRADE_FINISHED")   //验证支付发过来的消息，签名是否正确
        {
            Users user = Users.GetSessionUser();

            if (user == null)
            {
                user = new Users();
                user.ID = ShoveEL._Convert.StrToInt(subject_UnEncrypt, -1);

                if (user.ID < 0)
                {
                    PublicFunction.WriteLog("校验用户信息出错!(用户ID)(Notify)");
                    Response.Write("fail");
                    return;
                }

                int Result = user.GetUserInfoByID();
                if ((Result != 0) && (Result != -3))
                {
                    PublicFunction.WriteLog("校验用户信息出错!(读取用户信息出错)(Notify)");
                    Response.Write("fail");
                    return;
                }
            }

            if (user.ID != ShoveEL._Convert.StrToInt(subject_UnEncrypt, -1))
            {
                PublicFunction.WriteLog("校验用户信息出错!(用户ID比较)(Notify)");
                Response.Write("fail");
                return;
            }

            if (WriteUserAccount(user, out_trade_no, total_fee.ToString(), "系统交易号：" + out_trade_no + ",支付宝交易号：" + trade_no))
            {
                Response.Write("success");     //返回给支付宝消息，成功
                return;
            }
            else
            {
                PublicFunction.WriteLog("写入返回数据出错！(Notify)");
                Response.Write("fail");
                return;
            }

            return;
        }
        else
        {
            Response.Write("fail");
            return;
        }
    }

    private bool WriteUserAccount(Users user, string orderid, string amount, string Memo)
    {
        double Money = ShoveEL._Convert.StrToDouble(amount, 0);
        if (Money == 0)
        {
            return false;
        }

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_Alipay_CommissionScale", 0) / 100;
        double Commission = Money - Math.Round(Money / (CommissionScale + 1), 2);
        Money -= Commission;

        string Return = "";
        bool ok = (user.AddUserBalance_1(Money, Commission, orderid, "支付宝支付", "", "", ref Return) == 0);

        if (!ok)
        {
            DataTable dt = DAL.Tables.UsersPayDetail.Select("Result", "[id] = " + ShoveEL._Convert.StrToLong(orderid, 0).ToString(), "");
            if (dt == null || dt.Rows.Count == 0)
            {
                PublicFunction.WriteLog("返回的交易号找不到对应的数据");
                return false;
            }

            int IsOK = ShoveEL._Convert.StrToInt(dt.Rows[0][0].ToString(), 0);
            if (IsOK == 1)
            {
                return true;
            }
            else
            {
                PublicFunction.WriteLog("对应的数据未处理");
                return false;
            }
        }

        return ok;
    }
}
