﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using Gateway;

public partial class OnlinePay_Alipay_Send2 : MemberPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        bool OnlinePay_Alipay_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_Alipay_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_Alipay_UserName"), PublicFunction.GetOptionsAsString("OnlinePay_Alipay_ON_Cert"), "SPAYC");
        if (!OnlinePay_Alipay_Status_ON)
        {
            Response.Write("暂未开通");
            Response.End();
            return;
        }

        this.PayMoney.Enabled = false;
        double money = 0;
        if (!IsPostBack)
        {
            string PayMoneys = Request["PayMoney"];
            if (user.SuperManagementRights)
            {
                money = ShoveEL._Convert.StrToDouble(PayMoneys.ToString(), 0);
                if (money < 0.01)
                {
                    this.PayMoney.Enabled = true;
                    OnlinePayed.Enabled = true;
                    bt_Submit.Enabled = false;

                    ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                    return;
                }
            }
            else
            {
                money = ShoveEL._Convert.StrToInt(PayMoneys.ToString(), 0);
                if (money < 1)
                {
                    this.PayMoney.Enabled = true;
                    OnlinePayed.Enabled = true;
                    bt_Submit.Enabled = false;

                    ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                    return;
                }
            }

            double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_Alipay_CommissionScale", 0) / 100;
            double Commission = Math.Round(money * CommissionScale, 2);

            money += Commission;
            this.PayMoney.Enabled = true;
            this.PayMoney.Text = money.ToString();
            labCommission.Text = "手续费 " + Commission.ToString() + " 元由支付网关提供商收取。";

            this.PayMoney.Enabled = false;
            bt_Submit.Enabled = true;
        }
    }

    protected void bt_Submit_Click(object sender, EventArgs e)
    {
        //业务参数赋值；
        string gateway = "https://www.alipay.com/cooperate/gateway.do?";	                //支付接口
        string service = "create_direct_pay_by_user";
        string sign_type = "MD5";
        string payment_type = "1";                                                          //支付类型
        string _input_charset = "utf-8";                                                    //编码类型
        string return_url = PublicFunction.GetSiteUrl() + "/OnlinePay/Alipay/Receive.aspx"; //服务器通知返回接口
        string notify_url = PublicFunction.GetSiteUrl() + "/OnlinePay/Alipay/Notify.aspx";  //服务器通知返回接口(暂时不用)
        string partner = PublicFunction.GetOptionsAsString("OnlinePay_Alipay_UserNumber");  //卖家商户号
        string show_url = PublicFunction.GetOptionsAsString("OnlinePay_Alipay_HomePage");
        string seller_email = PublicFunction.GetOptionsAsString("OnlinePay_Alipay_UserName");//卖家支付宝名称(邮箱)
        string key = PublicFunction.GetOptionsAsString("OnlinePay_Alipay_MD5");
        string agentID = "2088001456282873";

        //构造商品名称
        string subject = ShoveEL._Security.Encrypt.EncryptString(user.ID.ToString());	                //商品名称,作为加密的用户ID用

        string body = "预付款";                                                             //商品描述
        double PayMoney = Convert.ToDouble(this.PayMoney.Text.Trim());
        string total_fee = PayMoney.ToString();                                             //总金额 0.01～50000.00        

        long PayNumber = -1;
        string Return = "";
        if (DAL.Procedures.P_GetNewPayNumber.Call(user.ID, "Alipay", PayMoney, ref PayNumber, ref Return) < 0)
        {
            GoError("数据读取错误。");
            return;
        }
        if ((PayNumber < 0) || (Return != ""))
        {
            GoError(Return);
            return;
        }

        string out_trade_no = PayNumber.ToString();

        AliPay ap = new AliPay();
        string aliay_url = ap.CreatUrl(
            gateway,
            service,
            partner,
            sign_type,
            out_trade_no,
            subject,
            body,
            payment_type,
            total_fee,
            show_url,
            seller_email,
            key,
            return_url,
            _input_charset,
            notify_url,
            agentID
            );
        
        this.Response.Write("<script language='javascript'>window.top.location.href='" + aliay_url + "'</script>");
    }

    protected void OnlinePayed_Click(object sender, System.EventArgs e)
    {
        double money = 0;

        if (user.SuperManagementRights)
        {
            money = ShoveEL._Convert.StrToDouble(this.PayMoney.Text.Trim(), 0);
            if (money < 0.01)
            {
                this.PayMoney.Enabled = true;
                OnlinePayed.Enabled = true;
                bt_Submit.Enabled = false;

                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }
        else
        {
            money = ShoveEL._Convert.StrToInt(this.PayMoney.Text.Trim(), 0);
            if (money < 1)
            {
                this.PayMoney.Enabled = true;
                OnlinePayed.Enabled = true;
                bt_Submit.Enabled = false;

                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_99Bill_CommissionScale", 0) / 100;
        double Commission = Math.Round(money * CommissionScale, 2);

        money += Commission;
        this.PayMoney.Enabled = true;
        this.PayMoney.Text = money.ToString();
        labCommission.Text = "手续费 " + Commission.ToString() + " 元由支付网关提供商收取。";

        this.PayMoney.Enabled = false;
        OnlinePayed.Enabled = false;
        bt_Submit.Enabled = true;
    }
}