﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using cn.com.chinabank.CBSecurity;

public partial class OnlinePay_CBPayMent_Receive : System.Web.UI.Page
{
    private string v_oid; //订单号
    private string v_pstatus; //支付状态码
    //20（支付成功，对使用实时银行卡进行扣款的订单）；
    //30（支付失败，对使用实时银行卡进行扣款的订单）；

    private string v_pstring;       //支付状态描述
    private string v_pmode;         //支付银行
    private string v_md5info;       //MD5校验码
    private string v_amount;        //支付金额
    private string v_moneytype;     //币种		
    private string remark1;         //备注1
    private string remark1_UnEncrypt = "";
    private string remark2;         //备注1

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_CBPayMent_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_CBPayMent_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_CBPayMent_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_CBPayMent_ON_Cert"), "SPAYC");
        if (!OnlinePay_CBPayMent_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }

        if (!this.IsPostBack)
        {
            try
            {
                v_oid = Request["v_oid"].ToString();
                v_pstatus = Request["v_pstatus"].ToString();
                v_pstring = Request["v_pstring"].ToString();
                v_pmode = Request["v_pmode"].ToString();
                v_md5info = Request["v_md5str"].ToString();
                v_amount = Request["v_amount"].ToString();
                v_moneytype = Request["v_moneytype"].ToString();	//v_moneytype = "0";
                remark1 = Request["remark1"].ToString();
                remark1_UnEncrypt = ShoveEL._Security.Encrypt.UnEncryptString(remark1);
                remark2 = Request["remark2"].ToString();
            }
            catch
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            Users user = Users.GetSessionUser();

            if (user == null)
            {
                user = new Users();
                user.ID = ShoveEL._Convert.StrToInt(remark1_UnEncrypt, -1);

                if (user.ID < 0)
                {
                    //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }

                int Result = user.GetUserInfoByID();
                if ((Result != 0) && (Result != -3))
                {
                    //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }
            }

            if (user.ID != ShoveEL._Convert.StrToInt(remark1_UnEncrypt, -1))
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            string str = v_oid + v_pstatus + v_amount + v_moneytype + PublicFunction.GetOptionsAsString("OnlinePay_CBPayMent_MD5");
            int tran_status = ShoveEL._Convert.StrToInt(v_pstatus, -1);

            // tran_status: 20: 成功
            if ((tran_status == 20) && MD5Util.verifyMD5(str, v_md5info))
            {
                WriteUserAccount(user);
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + remark1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx'</script>");
                Response.Redirect(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + remark1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx", true);
                return;
            }
            else
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + remark1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx'</script>");
                Response.Redirect(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + remark1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx", true);
                return;
            }
        }
    }

    private bool WriteUserAccount(Users user)
    {
        double Money = ShoveEL._Convert.StrToDouble(v_amount, 0);
        if (Money == 0)
            return false;

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_CBPayMent_CommissionScale", 0) / 100;
        double Commission = Money - Math.Round(Money / (CommissionScale + 1), 2);
        Money -= Commission;

        string Return = "";
        bool ok = (user.AddUserBalance_1(Money, Commission, v_oid, "网银在线" + v_pmode, "", "", ref Return) == 0);

        return ok;
    }
}