﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Globalization;
using System.Text.RegularExpressions;
using cn.com.chinabank.CBSecurity;

public partial class OnlinePay_CBPayMent_Send : MemberPage
{
    protected string pmode_id;
    protected string v_rcvname;
    protected string v_rcvaddr;
    protected string v_rcvtel;
    protected string v_ordername;
    protected string v_orderstatus;
    protected string v_amount;
    protected string v_moneytype;
    protected string v_md5info;
    protected string v_mid;
    protected string v_url;
    protected string v_oid;
    protected string v_ymd;
    protected string v_rcvpost;
    protected string v_ordermail;
    protected string remark1, remark2;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_CBPayMent_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_CBPayMent_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_CBPayMent_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_CBPayMent_ON_Cert"), "SPAYC");
        if (!OnlinePay_CBPayMent_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "OnlinePay/CBPayMent/Send.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindInfo()
    {
        v_rcvname = user.Name;
        v_rcvaddr = user.Address;
        v_rcvtel = user.Telphone;
        v_ordername = user.Name;
        //v_rcvpost = user.PostCode;
        v_ordermail = user.Email;
        remark1 = ShoveEL._Security.Encrypt.EncryptString(user.ID.ToString());            //私有参数,放的充值的用户ID
        remark2 = "";

        System.DateTime dt = System.DateTime.Now;
        v_ymd = dt.ToString("yyyyMMdd", DateTimeFormatInfo.InvariantInfo);
        string timeStr = dt.ToString("HHmmss", DateTimeFormatInfo.InvariantInfo);
        v_mid = PublicFunction.GetOptionsAsString("OnlinePay_CBPayMent_UserNumber");
        v_moneytype = "0";//"CNY"
        v_url = PublicFunction.GetSiteUrl() + "/OnlinePay/CBPayMent/Receive.aspx";

        double PayMoney = Convert.ToDouble(this.PayMoney.Text.Trim());
        v_amount = PayMoney.ToString();

        long PayNumber = 0;
        string Return = "";

        if (DAL.Procedures.P_GetNewPayNumber.Call(user.ID, "CBPayMent", PayMoney, ref PayNumber, ref Return) < 0)
        {
            GoError("数据读取错误。");
            return;
        }
        if ((PayNumber < 0) || (Return != ""))
        {
            GoError(Return);
            return;
        }

        v_oid = PayNumber.ToString();

        String ScrtStr = v_amount + v_moneytype + v_oid + v_mid + v_url + PublicFunction.GetOptionsAsString("OnlinePay_CBPayMent_MD5");
        v_md5info = MD5Util.getMD5(ScrtStr);
    }

    protected void OnlinePayed_Click(object sender, System.EventArgs e)
    {
        double money = 0;

        if (user.SuperManagementRights)
        {
            money = ShoveEL._Convert.StrToDouble(this.PayMoney.Text.Trim(), 0);
            if (money < 0.01)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }
        else
        {
            money = ShoveEL._Convert.StrToInt(this.PayMoney.Text.Trim(), 0);
            if (money < 1)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_CBPayMent_CommissionScale", 0) / 100;
        double Commission = Math.Round(money * CommissionScale, 2);

        money += Commission;
        this.PayMoney.Text = money.ToString();
        labCommission.Text = "手续费 " + Commission.ToString() + " 元由支付网关提供商收取。";

        this.PayMoney.Enabled = false;
        OnlinePayed.Enabled = false;

        BindInfo();

        this.Panel1.Visible = true;
    }
}