﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Web.Security;

public partial class OnlinePay_CnCard_Receive : System.Web.UI.Page
{
    protected string c_mid;			//商户编号，在申请商户成功后即可获得，可以在申请商户成功的邮件中获取该编号
    protected string c_order;		//商户提供的订单号
    protected string c_orderamount; //商户提供的订单总金额，以元为单位，小数点后保留两位，如：13.05
    protected string c_ymd;			//商户传输过来的订单产生日期，格式为"yyyymmdd"，如20050102
    protected string c_transnum;	//云网支付网关提供的该笔订单的交易流水号，供日后查询、核对使用；
    protected string c_succmark;	//交易成功标志，Y-成功 N-失败
    protected string c_moneytype;	//支付币种，0为人民币
    protected string c_cause;		//如果订单支付失败，则该值代表失败原因
    protected string c_memo1;		//商户提供的需要在支付结果通知中转发的商户参数一
    protected string c_memo1_UnEncrypt;
    protected string c_memo2;		//商户提供的需要在支付结果通知中转发的商户参数二
    protected string c_signstr;		//云网支付网关对已上信息进行MD5加密后的字符串

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_CnCard_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_CnCard_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_CnCard_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_CnCard_ON_Cert"), "SPAYC");
        if (!OnlinePay_CnCard_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }

        if (!this.IsPostBack)
        {
            try
            {
                c_mid = Request["c_mid"].ToString();
                c_order = Request["c_order"].ToString();
                c_orderamount = Request["c_orderamount"].ToString();
                c_ymd = Request["c_ymd"].ToString();
                c_transnum = Request["c_transnum"].ToString();
                c_succmark = Request["c_succmark"].ToString();
                c_moneytype = Request["c_moneytype"].ToString();
                c_cause = Request["c_cause"].ToString();
                c_memo1 = Request["c_memo1"].ToString();
                c_memo1_UnEncrypt = ShoveEL._Security.Encrypt.UnEncryptString(c_memo1);
                c_memo2 = Request["c_memo2"].ToString();
                c_signstr = Request["c_signstr"].ToString();
            }
            catch
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            if (c_mid != PublicFunction.GetOptionsAsString("OnlinePay_CnCard_UserNumber"))
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            if (c_succmark != "Y" && c_succmark != "N")
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            Users user = Users.GetSessionUser();

            if (user == null)
            {
                user = new Users();
                user.ID = ShoveEL._Convert.StrToInt(c_memo1_UnEncrypt, -1);

                if (user.ID < 0)
                {
                    //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }

                int Result = user.GetUserInfoByID();
                if ((Result != 0) && (Result != -3))
                {
                    //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }
            }

            if (user.ID != ShoveEL._Convert.StrToInt(c_memo1_UnEncrypt, -1))
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            string srcStr = c_mid + c_order + c_orderamount + c_ymd + c_transnum + c_succmark + c_moneytype + c_memo1 + c_memo2 + PublicFunction.GetOptionsAsString("OnlinePay_CnCard_MD5");
            if (c_signstr != FormsAuthentication.HashPasswordForStoringInConfigFile(srcStr, "MD5").ToLower())
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            if (c_succmark == "Y")
            {
                WriteUserAccount(user);
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + c_memo1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx'</script>");
                Response.Redirect(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + c_memo1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx", true);
                return;
            }
            else
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + c_memo1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx'</script>");
                Response.Redirect(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + c_memo1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx", true);
                return;
            }
        }
    }

    private bool WriteUserAccount(Users user)
    {
        double Money = ShoveEL._Convert.StrToDouble(c_orderamount, 0);
        if (Money == 0)
            return false;

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_CnCard_CommissionScale", 0) / 100;
        double Commission = Money - Math.Round(Money / (CommissionScale + 1), 2);
        Money -= Commission;

        string Return = "";
        bool ok = (user.AddUserBalance_1(Money, Commission, c_order, "云网支付" + c_transnum, "", "", ref Return) == 0);

        return ok;
    }
}