﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Globalization;
using System.Text.RegularExpressions;
using System.Web.Security;

public partial class OnlinePay_CnCard_Send : MemberPage
{
    protected string c_mid;
    protected string c_order;
    protected string c_orderamount;
    protected string c_ymd;
    protected string c_moneytype;
    protected string c_retflag;
    protected string c_paygate;
    protected string c_returl;
    protected string c_memo1;
    protected string c_memo2;
    protected string c_language;
    protected string notifytype;
    protected string c_signstr;

    protected string c_name;
    protected string c_address;
    protected string c_post;
    protected string c_tel;
    protected string c_email;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_CnCard_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_CnCard_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_CnCard_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_CnCard_ON_Cert"), "SPAYC");
        if (!OnlinePay_CnCard_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "OnlinePay/CnCard/Send.aspx";
        base.OnInit(e);
    }
    #endregion

    private void BindInfo()
    {
        System.DateTime dt = System.DateTime.Now;

        c_name = user.Name;
        c_address = user.Address;
        c_post = ""; //user.PostCode;
        c_tel = user.Telphone;
        c_email = user.Email;

        c_memo1 = ShoveEL._Security.Encrypt.EncryptString(user.ID.ToString());            //私有参数,放的充值的用户ID
        c_memo2 = "";

        c_mid = PublicFunction.GetOptionsAsString("OnlinePay_CnCard_UserNumber");
        c_ymd = dt.ToString("yyyyMMdd", DateTimeFormatInfo.InvariantInfo);

        double PayMoney = Convert.ToDouble(this.PayMoney.Text.Trim());
        c_orderamount = PayMoney.ToString();

        long PayNumber = 0;
        string Return = "";

        if (DAL.Procedures.P_GetNewPayNumber.Call(user.ID, "CnCard", PayMoney, ref PayNumber, ref Return) < 0)
        {
            GoError("数据读取错误。");
            return;
        }
        if ((PayNumber < 0) || (Return != ""))
        {
            GoError(Return);
            return;
        }

        c_order = PayNumber.ToString();
        c_moneytype = "0";  //人民币
        c_retflag = "1";    //商户订单支付成功后是否需要返回商户指定的文件，0：不用返回 1：需要返回
        c_paygate = "";     //如果在商户网站选择银行则设置该值，具体值可参见《云网支付@网技术接口手册》附录一；如果来云网支付@网选择银行此项为空值。
        c_returl = PublicFunction.GetSiteUrl() + "/OnlinePay/CnCard/Receive.aspx";
        c_language = "0";   //对启用了国际卡支付时，可使用该值定义消费者在银行支付时的页面语种，值为：0银行页面显示为中文/1银行页面显示为英文
        notifytype = "1";   //0普通通知方式/1服务器通知方式，空值为普通通知方式

        string srcStr = c_mid + c_order + c_orderamount + c_ymd + c_moneytype + c_retflag + c_returl + c_paygate + c_memo1 + c_memo2 + notifytype + c_language + PublicFunction.GetOptionsAsString("OnlinePay_CnCard_MD5");
        c_signstr = FormsAuthentication.HashPasswordForStoringInConfigFile(srcStr, "MD5").ToLower();
    }

    protected void OnlinePayed_Click(object sender, System.EventArgs e)
    {
        double money = 0;

        if (user.SuperManagementRights)
        {
            money = ShoveEL._Convert.StrToDouble(this.PayMoney.Text.Trim(), 0);
            if (money < 0.01)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }
        else
        {
            money = ShoveEL._Convert.StrToInt(this.PayMoney.Text.Trim(), 0);
            if (money < 1)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_CnCard_CommissionScale", 0) / 100;
        double Commission = Math.Round(money * CommissionScale, 2);

        money += Commission;
        this.PayMoney.Text = money.ToString();
        labCommission.Text = "手续费 " + Commission.ToString() + " 元由支付网关提供商收取。";

        this.PayMoney.Enabled = false;
        OnlinePayed.Enabled = false;

        BindInfo();

        this.Panel1.Visible = true;
    }
}