﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;

public partial class OnlinePay_ICBC_Receive : System.Web.UI.Page
{
    private string interfaceName = "";
    private string interfaceVersion = "";
    private string orderid = "";
    private string TranSerialNo = "";
    private string amount = "";
    private string curType = "";
    private string merID = "";
    private string merAcct = "";
    private string verifyJoinFlag = "";
    private string JoinFlag = "";
    private string UserNum = "";
    private string resultType = "";
    private string orderDate = "";
    private string notifyDate = "";
    private string tranStat = "";
    private string comment = "";
    private string remark1 = "";
    private string remark1_UnEncrypt = "";
    private string remark2 = "";
    private string signMsg = "";

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_ICBC_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_ICBC_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_ICBC_merID"), PublicFunction.GetOptionsAsString("OnlinePay_ICBC_ON_Cert"), "SPAYC");
        if (!OnlinePay_ICBC_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }

        if (!IsPostBack)
        {
            try
            {
                interfaceName = Request["interfaceName"];
                interfaceVersion = Request["interfaceVersion"];
                orderid = Request["orderid"];
                TranSerialNo = Request["TranSerialNo"];
                amount = Request["amount"];
                curType = Request["curType"];
                merID = Request["merID"];
                merAcct = Request["merAcct"];
                verifyJoinFlag = Request["verifyJoinFlag"];
                JoinFlag = Request["JoinFlag"];
                UserNum = Request["UserNum"];
                resultType = Request["resultType"];
                orderDate = Request["orderDate"];
                notifyDate = Request["notifyDate"];
                tranStat = Request["tranStat"];
                comment = Request["comment"];
                remark1 = Request["remark1"];
                remark1_UnEncrypt = ShoveEL._Security.Encrypt.UnEncryptString(remark1);
                remark2 = Request["remark2"];
                signMsg = Request["signMsg"].Replace("%2B", "+").Replace("%2F", "/").Replace("%3D", "=");
            }
            catch
            {
                Response.Clear();
                Response.Write(PublicFunction.GetSiteUrl() + "/Error.aspx");
                Response.End();
                return;
            }

            if (merID != PublicFunction.GetOptionsAsString("OnlinePay_ICBC_merID"))
            {
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            if (orderid.Length < 9)
            {
                Response.Clear();
                Response.Write(PublicFunction.GetSiteUrl() + "/Error.aspx");
                Response.End();
                return;
            }

            Users user = Users.GetSessionUser();

            if (user == null)
            {
                user = new Users();
                user.ID = ShoveEL._Convert.StrToInt(remark1_UnEncrypt, -1);

                if (user.ID < 0)
                {
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }

                int Result = user.GetUserInfoByID();
                if ((Result != 0) && (Result != -3))
                {
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }
            }

            if (user.ID != ShoveEL._Convert.StrToInt(remark1_UnEncrypt, -1))
            {
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            string src = "interfaceName=" + interfaceName + "&interfaceVersion=" + interfaceVersion + "&orderid=" + orderid + "&TranSerialNo=" +
                TranSerialNo + "&amount=" + amount + "&curType=" + curType + "&merID=" + merID + "&merAcct=" + merAcct + "&verifyJoinFlag=" +
                verifyJoinFlag + "&JoinFlag=" + JoinFlag + "&UserNum=" + UserNum + "&resultType=" + resultType + "&orderDate=" + orderDate + "&notifyDate=" +
                notifyDate + "&tranStat=" + tranStat + "&comment=" + comment + "&remark1=" + remark1 + "&remark2=" + remark2;

            int rc = verifySignC(src, signMsg);
            if (rc != 0)
            {
                Response.Clear();
                Response.Write(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + remark1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx");
                Response.End();
                return;
            }

            if (tranStat.Trim() == "2")
            {
                Response.Clear();
                Response.Write(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + remark1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx");
                Response.End();
                return;
            }
            if (tranStat.Trim() == "3")
            {
                Response.Clear();
                Response.Write(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + remark1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx");
                Response.End();
                return;
            }

            WriteUserAccount(user);

            Response.Clear();
            Response.Write(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + remark1 + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx");
            Response.End();
        }
    }

    private int verifySignC(string src, string sSrc)
    {
        // Return
        //	0：成功	-1：验证失败	-2：解码失败	-100:明文字符串传递有误	-101:签名字符串传递有误
        //	-1000 证书读取失败		-1001 证书校验出现异常

        ICBCEBANKUTILLib.B2CUtilClass icbc = new ICBCEBANKUTILLib.B2CUtilClass();

        string OnlinePay_ICBC_PublicCertFile = "Cert/" + PublicFunction.GetOptionsAsString("OnlinePay_ICBC_PublicCertFile").Trim();
        string OnlinePay_ICBC_PublicCertKeyFile = "Cert/" + PublicFunction.GetOptionsAsString("OnlinePay_ICBC_PublicCertKeyFile").Trim();
        string OnlinePay_ICBC_UserCertFile = "Cert/" + PublicFunction.GetOptionsAsString("OnlinePay_ICBC_UserCertFile").Trim();
        string OnlinePay_ICBC_UserCertKeyFile = "Cert/" + PublicFunction.GetOptionsAsString("OnlinePay_ICBC_UserCertKeyFile").Trim();
        string OnlinePay_ICBC_UserCertPassword = PublicFunction.GetOptionsAsString("OnlinePay_ICBC_UserCertPassword").Trim();

        int rc = 0;
        try
        {
            rc = icbc.init(this.Server.MapPath(OnlinePay_ICBC_PublicCertFile), this.Server.MapPath(OnlinePay_ICBC_UserCertFile), this.Server.MapPath(OnlinePay_ICBC_UserCertKeyFile), OnlinePay_ICBC_UserCertPassword);
        }
        catch
        {
            return -1000;
        }

        if (rc != 0)
            return -1000;

        try
        {
            rc = icbc.verifySignC(src, src.Length, sSrc, sSrc.Length);
        }
        catch
        {
            return -1001;
        }

        return rc;
    }

    private bool WriteUserAccount(Users user)
    {
        double Money = ShoveEL._Convert.StrToDouble(amount, 0) / 100;
        if (Money == 0)
            return false;

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_ICBC_CommissionScale", 0) / 100;
        double Commission = Money - Math.Round(Money / (CommissionScale + 1), 2);
        Money -= Commission;

        string Return = "";
        bool ok = (user.AddUserBalance_1(Money, Commission, orderid, "工行支付", "", "", ref Return) == 0);

        return ok;
    }
}