﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using System.Text.RegularExpressions;

public partial class OnlinePay_ICBC_Send : MemberPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_ICBC_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_ICBC_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_ICBC_merID"), PublicFunction.GetOptionsAsString("OnlinePay_ICBC_ON_Cert"), "SPAYC");
        if (!OnlinePay_ICBC_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }

        divPay.Visible = false;
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "OnlinePay/ICBC/Send.aspx";
        base.OnInit(e);
    }
    #endregion

    private bool GetCert(string src, ref string sSrc, ref string sCert)
    {
        ICBCEBANKUTILLib.B2CUtilClass icbc = new ICBCEBANKUTILLib.B2CUtilClass();

        string OnlinePay_ICBC_PublicCertFile = "Cert/" + PublicFunction.GetOptionsAsString("OnlinePay_ICBC_PublicCertFile").Trim();
        string OnlinePay_ICBC_PublicCertKeyFile = "Cert/" + PublicFunction.GetOptionsAsString("OnlinePay_ICBC_PublicCertKeyFile").Trim();
        string OnlinePay_ICBC_UserCertFile = "Cert/" + PublicFunction.GetOptionsAsString("OnlinePay_ICBC_UserCertFile").Trim();
        string OnlinePay_ICBC_UserCertKeyFile = "Cert/" + PublicFunction.GetOptionsAsString("OnlinePay_ICBC_UserCertKeyFile").Trim();
        string OnlinePay_ICBC_UserCertPassword = PublicFunction.GetOptionsAsString("OnlinePay_ICBC_UserCertPassword").Trim();

        int rc = 0;
        try
        {
            rc = icbc.init(this.Server.MapPath(OnlinePay_ICBC_UserCertFile), this.Server.MapPath(OnlinePay_ICBC_UserCertFile), this.Server.MapPath(OnlinePay_ICBC_UserCertKeyFile), OnlinePay_ICBC_UserCertPassword);
        }
        catch
        {
            return false;
        }

        if (rc != 0)
            return false;

        sSrc = "";
        try
        {
            sSrc = icbc.signC(src, src.Length);
        }
        catch
        {
            return false;
        }

        if (sSrc == "")
            return false;

        try
        {
            sCert = icbc.getCert(1);
        }
        catch
        {
            return false;
        }

        if (sCert == "")
            return false;

        return true;
    }

    private string GetDateTimeString()
    {
        DateTime dt = System.DateTime.Now;
        return dt.Year.ToString().PadLeft(4, '0') + dt.Month.ToString().PadLeft(2, '0') + dt.Day.ToString().PadLeft(2, '0') +
            dt.Hour.ToString().PadLeft(2, '0') + dt.Minute.ToString().PadLeft(2, '0') + dt.Second.ToString().PadLeft(2, '0');
    }

    protected void btnMoney_Click(object sender, System.EventArgs e)
    {
        double PayMoney = 0;

        if (user.SuperManagementRights)
        {
            PayMoney = Math.Round(ShoveEL._Convert.StrToDouble(this.tbMoney.Text.Trim(), 0), 2);
            if (PayMoney < 0.01)
            {
                Label3.Visible = false;
                labCommission.Visible = false;
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }
        else
        {
            PayMoney = ShoveEL._Convert.StrToInt(this.tbMoney.Text.Trim(), 0);
            if (PayMoney < 1)
            {
                Label3.Visible = false;
                labCommission.Visible = false;
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }

        btnMoney.Enabled = false;
        tbMoney.Enabled = false;
        Label3.Visible = true;
        labCommission.Visible = true;

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_ICBC_CommissionScale", 0) / 100;
        double Commission = Math.Round(PayMoney * CommissionScale, 2);

        PayMoney += Commission;
        tbMoney.Text = PayMoney.ToString();
        labCommission.Text = "手续费 " + Commission.ToString() + " 元由银行收取。";

        interfaceName.Value = PublicFunction.GetOptionsAsString("OnlinePay_ICBC_interfaceName");
        interfaceVersion.Value = PublicFunction.GetOptionsAsString("OnlinePay_ICBC_interfaceVersion");
        merID.Value = PublicFunction.GetOptionsAsString("OnlinePay_ICBC_merID");
        merAcct.Value = PublicFunction.GetOptionsAsString("OnlinePay_ICBC_merAcct");
        orderDate.Value = GetDateTimeString();
        remark1.Value = ShoveEL._Security.Encrypt.EncryptString(user.ID.ToString());            //私有参数,放的充值的用户ID

        curType.Value = "001";
        verifyJoinFlag.Value = "0";
        notifyType.Value = "HS";
        resultType.Value = "0";
        merURL.Value = PublicFunction.GetSiteUrl() + "/OnlinePay/ICBC/Receive.aspx";

        amount.Value = (PayMoney * 100).ToString();

        long PayNumber = 0;
        string Return = "";

        if (DAL.Procedures.P_GetNewPayNumber.Call(user.ID, "ICBC", PayMoney, ref PayNumber, ref Return) < 0)
        {
            GoError("数据读取错误。");
            return;
        }
        if ((PayNumber < 0) || (Return != ""))
        {
            GoError(Return);
            return;
        }

        orderid.Value = PayNumber.ToString();

        string src, sSrc = "", sCert = "";
        src = interfaceName.Value + interfaceVersion.Value + merID.Value + merAcct.Value +
            merURL.Value + notifyType.Value + orderid.Value + amount.Value + curType.Value + resultType.Value + orderDate.Value + verifyJoinFlag.Value;

        if (!GetCert(src, ref sSrc, ref sCert))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "客户证书读取失败，请联系客服中心予以解决，谢谢。");
            return;
        }

        merSignMsg.Value = sSrc;
        merCert.Value = sCert;
        divPay.Visible = true;
    }
}