﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class OnlinePay_Tenpay_Receive : System.Web.UI.Page
{
    private string cmdno = "";
    private string pay_result = "";
    private string pay_info = "";
    private string date = "";
    private string bargainor_id = "";
    private string transaction_id = "";
    private string sp_billno = "";
    private string total_fee = "";
    private string fee_type = "";
    private string attach = "";
    private string attach_UnEncrypt = "";
    private string sign = "";

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_Tenpay_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_Tenpay_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_Tenpay_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_Tenpay_ON_Cert"), "SPAYC");
        if (!OnlinePay_Tenpay_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }

        if (!this.IsPostBack)
        {
            try
            {
                cmdno = Request["cmdno"].ToString();
                pay_result = Request["pay_result"].ToString();
                pay_info = Request["pay_info"].ToString();
                date = Request["date"].ToString();
                bargainor_id = Request["bargainor_id"].ToString();
                transaction_id = Request["transaction_id"].ToString();
                sp_billno = Request["sp_billno"].ToString();
                total_fee = Request["total_fee"].ToString();
                fee_type = Request["fee_type"].ToString();
                attach = Request["attach"].ToString();
                attach_UnEncrypt = ShoveEL._Security.Encrypt.UnEncryptString(attach);
                sign = Request["sign"].ToString();
            }
            catch
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            if (bargainor_id != PublicFunction.GetOptionsAsString("OnlinePay_TenPay_UserNumber"))
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            Users user = Users.GetSessionUser();

            if (user == null)
            {
                user = new Users();
                user.ID = ShoveEL._Convert.StrToInt(attach_UnEncrypt, -1);

                if (user.ID < 0)
                {
                    //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }

                int Result = user.GetUserInfoByID();
                if ((Result != 0) && (Result != -3))
                {
                    //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                    this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                    return;
                }
            }

            if (user.ID != ShoveEL._Convert.StrToInt(attach_UnEncrypt, -1))
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Error.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Error.aspx", true);
                return;
            }

            string ScrtStr = "cmdno=" + cmdno + "&pay_result=" + pay_result + "&date=" + date + "&transaction_id=" + transaction_id + "&sp_billno=" + sp_billno + "&total_fee=" + total_fee + "&fee_type=" + fee_type + "&attach=" + attach + "&key=" + PublicFunction.GetOptionsAsString("OnlinePay_Tenpay_MD5");
            string mysign = System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(ScrtStr, "MD5");

            double Money = ShoveEL._Convert.StrToDouble(total_fee, 0) / 100;

            if ((sign == mysign) && (pay_result == "0"))
            {
                WriteUserAccount(user, sp_billno, Money);
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + attach + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + attach + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/OK.aspx", true);
                return;
            }
            else
            {
                //this.Response.Write("<script language='javascript'>window.top.location.href='" + PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + attach + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx'</script>");
                this.Response.Redirect(PublicFunction.GetSiteUrl() + "/Member.aspx?UID=" + attach + "&Key=" + ShoveEL._Security.Encrypt.EncryptString(DateTime.Now.ToString()) + "&SubPage=OnlinePay/Fail.aspx", true);
                return;
            }
        }
    }

    private bool WriteUserAccount(Users user, string orderid, double Money)
    {
        if (Money == 0)
            return false;

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_Tenpay_CommissionScale", 0) / 100;
        double Commission = Money - Math.Round(Money / (CommissionScale + 1), 2);
        Money -= Commission;

        string Return = "";
        bool ok = (user.AddUserBalance_1(Money, Commission, orderid, "财付通支付", "", "", ref Return) == 0);

        return ok;
    }
}