﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;

public partial class OnlinePay_Tenpay_Send : MemberPage
{
    public string cmdno;
    public string date;
    public string bank_type;
    public string desc;
    public string purchaser_id;
    public string bargainor_id;
    public string transaction_id;
    public string sp_billno;
    public string total_fee;
    public string fee_type;
    public string return_url;
    public string attach;
    public string sign;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        bool OnlinePay_Tenpay_Status_ON = PublicFunction.GetOptionsAsBoolean("OnlinePay_Tenpay_Status_ON", false) &&
            PublicFunction.ValidCert(PublicFunction.GetOptionsAsString("OnlinePay_Tenpay_UserNumber"), PublicFunction.GetOptionsAsString("OnlinePay_Tenpay_ON_Cert"), "SPAYC");
        if (!OnlinePay_Tenpay_Status_ON)
        {
            Response.Write("暂未启用");
            Response.End();
            return;
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        LastRequestPage = "OnlinePay/Tenpay/Send.aspx";
        base.OnInit(e);
    }
    #endregion

    private string GetDate()
    {
        DateTime dt = System.DateTime.Now;
        return dt.Year.ToString() + dt.Month.ToString().PadLeft(2, '0') + dt.Day.ToString().PadLeft(2, '0');
    }

    private void BindInfo()
    {
        cmdno = "1";
        date = GetDate();
        bank_type = "0";
        desc = "预付款";
        purchaser_id = "";
        bargainor_id = PublicFunction.GetOptionsAsString("OnlinePay_Tenpay_UserNumber");
        fee_type = "1";
        return_url = PublicFunction.GetSiteUrl() + "/OnlinePay/Tenpay/Receive.aspx";
        attach = ShoveEL._Security.Encrypt.EncryptString(user.ID.ToString());            //私有参数,放的充值的用户ID

        double PayMoney = Convert.ToDouble(this.PayMoney.Text.Trim());
        total_fee = (PayMoney * 100).ToString();

        long PayNumber = 0;
        string Return = "";

        if (DAL.Procedures.P_GetNewPayNumber.Call(user.ID, "TenPay", PayMoney, ref PayNumber, ref Return) < 0)
        {
            GoError("数据读取错误。");
            return;
        }
        if ((PayNumber < 0) || (Return != ""))
        {
            GoError(Return);
            return;
        }

        sp_billno = PayNumber.ToString();
        transaction_id = bargainor_id + date + PayNumber.ToString().PadLeft(10, '0');    //注意：PayNumbe要求是10位字符，暂时数据库可以保证，以后再说吧

        string ScrtStr = "cmdno=" + cmdno + "&date=" + date + "&bargainor_id=" + bargainor_id + "&transaction_id=" + transaction_id + "&sp_billno=" + sp_billno + "&total_fee=" + total_fee + "&fee_type=" + fee_type + "&return_url=" + return_url + "&attach=" + attach + "&key=" + PublicFunction.GetOptionsAsString("OnlinePay_Tenpay_MD5");
        sign = System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(ScrtStr, "MD5");
    }

    protected void OnlinePayed_Click(object sender, System.EventArgs e)
    {
        double money = 0;

        if (user.SuperManagementRights)
        {
            money = ShoveEL._Convert.StrToDouble(this.PayMoney.Text.Trim(), 0);
            if (money < 0.01)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }
        else
        {
            money = ShoveEL._Convert.StrToInt(this.PayMoney.Text.Trim(), 0);
            if (money < 1)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的充值金额！");
                return;
            }
        }

        double CommissionScale = PublicFunction.GetOptionsAsDouble("OnlinePay_Tenpay_CommissionScale", 0) / 100;
        double Commission = Math.Round(money * CommissionScale, 2);

        money += Commission;
        this.PayMoney.Text = money.ToString();
        labCommission.Text = "手续费 " + Commission.ToString() + " 元由支付网关提供商收取。";

        this.PayMoney.Enabled = false;
        OnlinePayed.Enabled = false;

        BindInfo();

        this.Panel1.Visible = true;
    }
}