﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using ShoveEL.Database;

public partial class Scheme : System.Web.UI.Page
{
    public Users user;
    protected int Scheme_id = -1;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        Response.Cache.SetCacheability(System.Web.HttpCacheability.NoCache);
      
        Scheme_id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
        if (Scheme_id < 1)
        {
            this.Response.Redirect("Index.aspx", true);
            return;
        }

        user = Users.GetSessionUser();

        if (user == null)
        {
            Response.Redirect("Error.aspx?ErrorNumber=02&LastRequestPage=Scheme.aspx?id=" + Scheme_id.ToString(), true);
            return;
        }

        if (!this.IsPostBack)
        {
            tbScheme_id.Text = Scheme_id.ToString();
            labBalance.Text = user.Balance.ToString("N");

            BindData();

            btnOK.Attributes.Add("onclick", "return btnOKClick();");

            bool isValidBuyPassword = PublicFunction.GetOptionsAsBoolean("isValidBuyPassword", true);
            if (isValidBuyPassword && user.isAlipayMember)  //如果普通用户需要输入投注密码，支付宝会员不需要
            {
                isValidBuyPassword = false;
            }
            panelInvestPassword.Visible = isValidBuyPassword;
        }
    }

    private void BindData()
    {
        DataTable dt = DAL.Views.V_SchemeScheduleWithQuashed.Select("", "[id] = " + tbScheme_id.Text, "");
        if ((dt == null) || (dt.Rows.Count < 1))
        {
            PublicFunction.GoError();
            return;
        }

        DataRow dr = dt.Rows[0];

        int InitiateUser_id = ShoveEL._Convert.StrToInt(dr["InitiateUser_id"].ToString(), 0);

        //既不是发起人，也不在招股对象之内
        if ((!user.isInOpenUserList(dr["OpenUserList"].ToString().Trim())) && (InitiateUser_id != user.ID) && !user.ManagementRights && !user.SuperManagementRights)
        {
            PublicFunction.GoError("对不起，您不在此方案的招股对象之内。");
            return;
        }

        string LotteryName = dr["Name"].ToString();
        Label1.Text = LotteryName + dr["Type"].ToString();
        Label2.Text = LotteryName + dr["Type"].ToString();
        Label3.Text = LotteryName + dr["Type"].ToString() + "认购方案";
        labTitle.Text = LotteryName + "第 " + dr["Isuse"].ToString() + " 期";
        labStartTime.Text = dr["StartTime"].ToString();
        labEndTime.Text = dr["SystemEndTime"].ToString();
        tbIsuse_id.Text = dr["id"].ToString();
        tbLottery_id.Text = dr["Lottery_id"].ToString();

        Label4.Text = "《<A class=li3 href='Agreement.aspx?id=" + tbLottery_id.Text + "' target='_blank'>" + LotteryName + "代购、合买协议</A>》";
        labInitiateUser.Text = dr["InitiateUser"].ToString() + "&nbsp;&nbsp;【<A class=li3 href='Score.aspx?id=" + dr["InitiateUser_id"].ToString() + "&LotteryType=" + tbLottery_id.Text + "' target='_blank'>发起人历史战绩</A>】";

        bool Quashed = ShoveEL._Convert.StrToBool(dr["Quashed"].ToString(), false);
        bool isSystemQuashed = ShoveEL._Convert.StrToBool(dr["isSystemQuashed"].ToString(), false);
        bool LotteryBuyed = ShoveEL._Convert.StrToBool(dr["LotteryBuyed"].ToString(), false);
        int Share = ShoveEL._Convert.StrToInt(dr["Share"].ToString(), 0);
        int BuyedShare = ShoveEL._Convert.StrToInt(dr["BuyedShare"].ToString(), 0);
        double Money = ShoveEL._Convert.StrToDouble(dr["Money"].ToString(), 0);
        double AssureMoney = ShoveEL._Convert.StrToDouble(dr["AssureMoney"].ToString(), 0);
        double WinMoney = ShoveEL._Convert.StrToDouble(dr["WinMoney"].ToString(), 0);
        int SecrecyLevel = ShoveEL._Convert.StrToInt(dr["SecrecyLevel"].ToString(), 0);
        bool IsuseOpenWined = false;

        DataTable dtIsuse = DAL.Tables.Isuse.Select("IsOpen", "[id] = " + dr["Isuse_id"].ToString(), "");
        if ((dtIsuse == null) || (dtIsuse.Rows.Count < 1))
        {
            PublicFunction.GoError();
            return;
        }
        IsuseOpenWined = ShoveEL._Convert.StrToBool(dtIsuse.Rows[0]["IsOpen"].ToString(), true);

        //能撤消整个方案
        bool isSurrogateBuyCanQuash = PublicFunction.GetOptionsAsBoolean("isSurrogateBuyCanQuash", false);
        if (isSurrogateBuyCanQuash)
        {
            int Type_id = ShoveEL._Convert.StrToInt(dr["Type_id"].ToString(), -1);
            if (!new Lottery()[int.Parse(tbLottery_id.Text)].isSurrogateBuyType(Type_id))
            {
                isSurrogateBuyCanQuash = false;
            }
        }
        if (!isSurrogateBuyCanQuash)
        {
            btnQuashScheme.Visible = ((!Quashed) && (!LotteryBuyed) && (Share > BuyedShare) && (InitiateUser_id == user.ID));
        }
        else
        {
            btnQuashScheme.Visible = ((!Quashed) && (!LotteryBuyed) && (InitiateUser_id == user.ID));
        }

        bool AtTop = ShoveEL._Convert.StrToBool(dr["AtTop"].ToString(), false);
        bool AtTopApplication = ShoveEL._Convert.StrToBool(dr["AtTopApplication"].ToString(), false);
        if (!AtTop)
        {
            cbAtTopApplication.Visible = ((!Quashed) && (InitiateUser_id == user.ID));
            cbAtTopApplication.Checked = AtTopApplication;
        }
        else
        {
            labAtTop.Visible = true;
        }

        bool CanBuy = false;
        bool Stop = false;
        System.DateTime EndTime = DateTime.Parse(labEndTime.Text);
        if (DateTime.Now >= EndTime)
        {
            Stop = true;
            tbStop.Text = Stop.ToString();
        }

        if (Quashed)
        {
            if (isSystemQuashed)
                labState.Text = "已撤单(系统撤单)";
            else
                labState.Text = "已撤单";
        }
        else
        {
            if (Stop)
                labState.Text = "已截止";
            else
            {
                if (LotteryBuyed)
                {
                    labState.Text = "<FONT color='red'>已成功</font>";
                }
                else
                {
                    if (Share <= BuyedShare)
                        labState.Text = "<FONT color='red'>已满员</font>";
                    else
                    {
                        labState.Text = "<font color='red'>抢购中...</font>";
                        CanBuy = true;
                    }
                }

                if (PublicFunction.GetOptionsAsBoolean("SchemeChatON", false))
                {
                    labState.Text += "&nbsp;&nbsp;<a href='Chat/SchemeChat.aspx?id=" + tbScheme_id.Text + "' target='_blank'><FONT color='red'>进入方案聊天室，参与讨论此方案</font></a>";
                }
            }
        }

        //  投住内容

        labMultiple.Text = dr["Multiple"].ToString();

        //  SecrecyLevel 0 不保密 1 到截止 2 到开奖 3 永远
        if ((SecrecyLevel == 1) && !Stop && (InitiateUser_id != user.ID) && !user.ManagementRights && !user.SuperManagementRights)
        {
            labLotteryNumber.Text = "投注内容已经被保密，将在本期投注截止后公开。";
        }
        else if ((SecrecyLevel == 2) && !IsuseOpenWined && (InitiateUser_id != user.ID) && !user.ManagementRights && !user.SuperManagementRights)
        {
            labLotteryNumber.Text = "投注内容已经被保密，将在本期开奖后公开。";
        }
        else if ((SecrecyLevel == 3) && (InitiateUser_id != user.ID) && !user.ManagementRights && !user.SuperManagementRights)
        {
            labLotteryNumber.Text = "投注内容已经被保密。";
        }
        else
        {
            string SchemeFileName = dr["FileName"].ToString().Trim();

            if (SchemeFileName != "")
            {
                if (!System.IO.File.Exists(this.Server.MapPath("SchemeFiles/" + dr["Name"].ToString() + "/" + dr["Isuse"].ToString() + "/" + dr["Type"].ToString() + "/" + SchemeFileName)))
                    SchemeFileName = "";
            }

            if (SchemeFileName != "")
            {
                linkDownloadScheme.Visible = true;
                labLotteryNumber.Visible = false;
                linkDownloadScheme.NavigateUrl = "SchemeFiles/" + dr["Name"].ToString() + "/" + dr["Isuse"].ToString() + "/" + dr["Type"].ToString() + "/" + SchemeFileName;
            }
            else
            {
                string t_str = "";
                try
                {
                    t_str = ShoveEL._String.Decompress((byte[])dr["LotteryNumber"]);
                }
                catch
                { }

                if (ShoveEL._String.StringAt(t_str, '\n') < PublicFunction.GetOptionsAsInt("SchemeMaxLotteryNumberRows", 0))
                {
                    if (ShoveEL._Convert.StrToInt(dr["Type_id"].ToString(), 0) >= Lottery.ZCDC.BuyType_SPF && ShoveEL._Convert.StrToInt(dr["Type_id"].ToString(), 0) < Lottery.ZCDC.BuyType_BQCSPF)
                    {
                        #region 单场的专用表格

                        string lotteryNumber = ShoveEL._Convert.ToHtmlCode(t_str);

                        string BuyContent = "";
                        string vote = "";
                        bool IsGetScheme = new Lottery()[Lottery.ZCDC.sID].GetSchemeSplit(lotteryNumber, ref BuyContent, ref vote);

                        string BuyType = lotteryNumber.Split(';')[0].ToString();

                        string[] Team = BuyContent.Split('|');

                        DataTable dtnew = new DataTable();
                        DataColumn newDC;

                        newDC = new DataColumn("No", System.Type.GetType("System.Int32"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("LeagueTypeName", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("HostTeam", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("QuestTeam", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("Content", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("LeagueColor", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("sp", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("LotteryResult", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("GamesResult", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        newDC = new DataColumn("HalftimeResult", System.Type.GetType("System.String"));
                        dtnew.Columns.Add(newDC);

                        for (int i = 0; i < Team.Length; i++)
                        {
                            DataTable dtp = null;

                            GetTeamInfo(Team[i].Split('(')[0], Scheme_id, ref dtp);

                            string TeamResult = Team[i].Split('(')[1].Substring(0, Team[i].Split('(')[1].Length - 1);

                            string LotteryResult = "";
                            string GamesResult = "";
                            string HalftimeResult = "";
                            string LetBall = "";
                            string sp = "";
                            if (BuyType == Lottery.ZCDC.BuyType_SPF.ToString())
                            {
                                TeamResult = TeamResult.Replace("0", "负").Replace("1", "平").Replace("3", "胜");

                                if (dtp.Rows[0]["SPFResult"] != null)
                                {
                                    LotteryResult = dtp.Rows[0]["SPFResult"].ToString();
                                    LotteryResult = LotteryResult.Replace("0", "负").Replace("1", "平").Replace("3", "胜");
                                }

                                if (dtp.Rows[0]["SPFSp"] != null)
                                {
                                    sp = dtp.Rows[0]["SPFSp"].ToString();
                                }
                            }

                            if (BuyType == Lottery.ZCDC.BuyType_ZJQ.ToString())
                            {
                                TeamResult = TeamResult.Replace("7", "7+");

                                if (dtp.Rows[0]["ZJQResult"] != null)
                                {
                                    LotteryResult = dtp.Rows[0]["ZJQResult"].ToString();
                                    LotteryResult = LotteryResult.Replace("7", "7+");
                                }

                                if (dtp.Rows[0]["ZJQSp"] != null)
                                {
                                    sp = dtp.Rows[0]["ZJQSp"].ToString();
                                }
                            }

                            if (BuyType == Lottery.ZCDC.BuyType_SXDS.ToString())
                            {
                                TeamResult = TeamResult.Replace("1", "上-单").Replace("2", "上-双").Replace("3", "下-单").Replace("4", "下-双");

                                if (dtp.Rows[0]["SXDSResult"] != null)
                                {
                                    LotteryResult = dtp.Rows[0]["SXDSResult"].ToString();
                                    LotteryResult = LotteryResult.Replace("1", "上-单").Replace("2", "上-双").Replace("3", "下-单").Replace("4", "下-双");
                                }

                                if (dtp.Rows[0]["SXDSSp"] != null)
                                {
                                    sp = dtp.Rows[0]["SXDSSp"].ToString();
                                }
                            }

                            string SaleTeam = "";
                            string SaleTeamResult = "";

                            if (BuyType == Lottery.ZCDC.BuyType_ZQBF.ToString())
                            {
                                string[] Teams = TeamResult.Split(',');
                                
                                for (int j = 0; j < Teams.Length; j++)
                                {

                                    if (Teams[j].Length > 1)
                                    {
                                        SaleTeam += Teams[j].Replace("25", "负其他").Replace("24", "2：4").Replace("23", "1:4").Replace("22", "0:4").Replace("21", "2:3").Replace("20", "1:3").Replace("19", "0:3").Replace("18", "1:2").Replace("17", "0:2").Replace("16", "0:1").Replace("15", "平其他").Replace("14", "3:3").Replace("13", "2:2").Replace("12", "1:1").Replace("11", "0:0").Replace("10", "胜其他");
                                    }
                                    else
                                    {
                                        SaleTeam += Teams[j].Replace("1", "1:0").Replace("2", "2:0").Replace("3", "2:1").Replace("4", "3:0").Replace("5", "3:1").Replace("6", "3:2").Replace("7", "4:0").Replace("8", "4:1").Replace("9", "4:2");

                                    }

                                    SaleTeam += ",";
                                }

                                TeamResult = SaleTeam.Substring(0, SaleTeam.Length - 1);

                                if (dtp.Rows[0]["ZQBFResult"] != null)
                                {
                                    string[] TeamsResult = dtp.Rows[0]["ZQBFResult"].ToString().Split(',');

                                    for (int j = 0; j < TeamsResult.Length; j++)
                                    {

                                        if (TeamsResult[j].Length > 1)
                                        {
                                            SaleTeamResult += TeamsResult[j].Replace("25", "负其他").Replace("24", "2：4").Replace("23", "1:4").Replace("22", "0:4").Replace("21", "2:3").Replace("20", "1:3").Replace("19", "0:3").Replace("18", "1:2").Replace("17", "0:2").Replace("16", "0:1").Replace("15", "平其他").Replace("14", "3:3").Replace("13", "2:2").Replace("12", "1:1").Replace("11", "0:0").Replace("10", "胜其他");
                                        }
                                        else
                                        {
                                            SaleTeamResult += TeamsResult[j].Replace("1", "1:0").Replace("2", "2:0").Replace("3", "2:1").Replace("4", "3:0").Replace("5", "3:1").Replace("6", "3:2").Replace("7", "4:0").Replace("8", "4:1").Replace("9", "4:2");

                                        }

                                        SaleTeamResult += ",";
                                    }

                                    LotteryResult = SaleTeamResult.Substring(0, SaleTeamResult.Length - 1);
                                }


                                if (dtp.Rows[0]["ZQBFSp"] != null)
                                {
                                    sp = dtp.Rows[0]["ZQBFSp"].ToString();
                                }

                            }

                            if (BuyType == Lottery.ZCDC.BuyType_BQCSPF.ToString())
                            {
                                TeamResult = TeamResult.Replace("1", "胜-胜").Replace("2", "胜-平").Replace("3", "胜-负").Replace("4", "平-胜").Replace("5", "平-平").Replace("6", "平-负").Replace("7", "负-胜").Replace("8", "负-平 ").Replace("9", "负-负");

                                if (dtp.Rows[0]["BQCSPFResult"] != null)
                                {
                                    LotteryResult = dtp.Rows[0]["BQCSPFResult"].ToString();
                                    LotteryResult = LotteryResult.Replace("1", "胜-胜").Replace("2", "胜-平").Replace("3", "胜-负").Replace("4", "平-胜").Replace("5", "平-平").Replace("6", "平-负").Replace("7", "负-胜").Replace("8", "负-平 ").Replace("9", "负-负");
                                }

                                if (dtp.Rows[0]["BQCSPFSp"] != null)
                                {
                                    sp = dtp.Rows[0]["BQCSPFSp"].ToString();
                                }
                            }

                            if (LotteryResult == "*")
                            {
                                LotteryResult = "延时";
                                sp = "1";
                            }

                            if (dtp.Rows[0]["Result"] != null)
                            {
                                GamesResult = dtp.Rows[0]["Result"].ToString();
                            }

                            if (dtp.Rows[0]["HalftimeResult"] != null)
                            {
                                HalftimeResult = dtp.Rows[0]["HalftimeResult"].ToString();
                            }

                            if (dtp.Rows[0]["LetBall"] != null)
                            {
                                LetBall = dtp.Rows[0]["LetBall"].ToString();
                            }

                            if (LetBall == "0")
                            {
                                LetBall = "";
                            }
                            else
                            {
                                LetBall = "[" + LetBall + "]";
                            }

                            DataRow dr1 = dtnew.NewRow();
                            dr1[0] = dtp.Rows[0]["No"].ToString();
                            dr1[1] = dtp.Rows[0]["LeagueTypeName"].ToString();
                            dr1[2] = dtp.Rows[0]["HostTeam"].ToString() + LetBall;
                            dr1[3] = dtp.Rows[0]["QuestTeam"].ToString();
                            dr1[4] = TeamResult;
                            dr1[5] = dtp.Rows[0]["LeagueColor"].ToString();
                            dr1[6] = sp;
                            dr1[7] = LotteryResult;
                            dr1[8] = GamesResult;
                            dr1[9] = HalftimeResult;
                            dtnew.Rows.Add(dr1);
                        }

                        labMultiple.Text = vote;
                        rptScheme.DataSource = dtnew;
                        rptScheme.DataBind();
                        rptScheme.Visible = true;

                        #endregion
                    }
                    else
                    {
                        labLotteryNumber.Text = ShoveEL._Convert.ToHtmlCode(t_str) + "&nbsp;";
                    }
                }
                else
                {
                    linkDownloadScheme.Visible = true;
                    labLotteryNumber.Visible = false;
                    linkDownloadScheme.NavigateUrl = "DownloadSchemeFile.aspx?id=" + tbScheme_id.Text;
                }
            }
        }

        // 填充
        labSchemeNumber.Text = dr["SchemeNumber"].ToString();
        labSchemeDateTime.Text = dr["DateTime"].ToString();
        labSchemeMoney.Text = ShoveEL._Convert.StrToDouble(dr["Money"].ToString(), 0).ToString("N");
        labSchemeTitle.Text = dr["Title"].ToString() + "&nbsp;";
        try
        {
            labSchemeDescription.Text = ShoveEL._Convert.ToHtmlCode(ShoveEL._String.Decompress((byte[])dr["Description"])) + "&nbsp;";
        }
        catch
        {
            labSchemeDescription.Text = "&nbsp;";
        }

        labSchemeADUrl.Text = this.Page.Request.Url.AbsoluteUri;
        labSchemeDetail.Text = string.Format("此方案总金额 <FONT color='red'>{0}</font> 元，共 <FONT color='red'>{1}</font> 份，每份 <FONT color='red'>{2}</font> 元。<BR>已认购 <FONT color='red'>{3}</font> 份（金额 <FONT color='red'>{4}</font> 元）", labSchemeMoney.Text, Share, (Money / Share).ToString("N"), BuyedShare, ((Money / Share) * BuyedShare).ToString("N")) +
                                (CanBuy ? string.Format("，还有 <FONT color='red'>{0}</font> 份（金额 <FONT color='red'>{1}</font> 元）可以认购！", Share - BuyedShare, ((Money / Share) * (Share - BuyedShare)).ToString("N")) : "");

        if (LotteryBuyed)
        {
            string LotteryCode = "";
            try
            {
                LotteryCode = ShoveEL._String.Decompress((byte[])dr["LotteryCode"]);
            }
            catch { }
            labLotteryCode.Text = "已出票，彩票标识：" + LotteryCode;
            linkDownloadLotteryCode.Visible = true;
            linkDownloadLotteryCode.NavigateUrl = "DownLoadLotteryCode.aspx?id=" + tbScheme_id.Text;
        }
        else
            labLotteryCode.Text = "暂未出票";

        labAssureMoney.Text = (AssureMoney > 0) ? string.Format("发起人保底 <FONT color='red'>{0}</font> 份，<FONT color='red'>{1}</font> 元", Math.Round(AssureMoney / (Money / Share), 0).ToString(), AssureMoney.ToString("N")) : "未保底";
        if (Quashed)
        {
            if (isSystemQuashed)
                labWin.Text = "已撤单(系统撤单)";
            else
                labWin.Text = "已撤单";
        }
        else
        {
            if (Stop)
            {
                labWin.Text = string.Format("<FONT color='red'>{0}</font> 元", WinMoney.ToString("N"));
                string WinDescription = "";
                try
                {
                    WinDescription = ShoveEL._String.Decompress((byte[])dr["WinDescription"]).Trim();
                }
                catch
                { }
                if (WinDescription != "")
                    labWin.Text += "<BR>" + WinDescription;
                else
                    labWin.Text += "  <font color='red'>【注】</font>中奖结果在开奖后需要一段时间才能显示。";
            }
            else
                labWin.Text = "尚未截止";
        }
        if (Stop)
        {
            labCannotBuyTip.Text = "方案已截止，不能认购";
            labCannotBuyTip.Visible = true;
            pBuy.Visible = false;
            btnOK.Enabled = false;
        }
        else
        {
            if (Quashed)
            {
                labCannotBuyTip.Text = "方案已撤单，不能认购";
                labCannotBuyTip.Visible = true;
                pBuy.Visible = false;
                btnOK.Enabled = false;
            }
            else
            {
                if (BuyedShare >= Share)
                {
                    labCannotBuyTip.Text = "方案已满员，不能认购";
                    labCannotBuyTip.Visible = true;
                    pBuy.Visible = false;
                    btnOK.Enabled = false;
                }
                else
                {
                    labCannotBuyTip.Visible = false;
                    pBuy.Visible = true;
                    btnOK.Enabled = true;
                }
            }
        }
        labShare.Text = (Share - BuyedShare).ToString();
        labShareMoney.Text = (Money / Share).ToString("N");

        DataTable dtUserList = MSSQL.Select("select *, Share * " + (Money / Share).ToString() + " as [Money] from V_LotteryBuyDetailWithUserName where Scheme_id = " + tbScheme_id.Text + " and Quashed = 0 order by [id]");
        if (dtUserList == null)
        {
            PublicFunction.GoError();
            return;
        }

        labUserList.Text = String.Format("总共有 <font color='red'>{0}</font> 个用户参与。", dtUserList.Rows.Count) +
            ((dtUserList.Rows.Count > 0) ? "&nbsp;&nbsp;【<A class=li3 href='javascript:onUserListClick();'>打开/隐藏明细</A>】" : "");

        gUserList.DataSource = dtUserList.DefaultView;
        gUserList.DataBind();

        DataTable dtMyBuy = DAL.Views.V_LotteryBuyDetailWithQuashedAll.Select("[id],[DateTime],[Money],Share,Quashed,LotteryBuyed,Isuse,Code,CanQuash,Schedule", "Scheme_id = " + tbScheme_id.Text + " and [User_id] = " + user.ID.ToString(), "[id]");
        if (dtMyBuy == null)
        {
            PublicFunction.GoError();
            return;
        }
        if (dtMyBuy.Rows.Count == 0)
        {
            labMyBuy.Text = "此方案还没有我的认购记录。";
            labMyBuy.Visible = true;
            g.Visible = false;
        }
        else
        {
            labMyBuy.Visible = false;
            g.Visible = true;
            g.DataSource = dtMyBuy.DefaultView;
            g.DataBind();
        }

        if (user.UserType != 2)
        {
            btnOK.Enabled = false;
            btnQuashScheme.Enabled = false;
        }
    }

    protected void GetTeamInfo(string No, int Scheme_id, ref DataTable dt)
    {
        dt = DAL.Views.V_ZCDCSchemeNumber.Select("*", "[id] = " + Scheme_id + "and No = " + No, "");
    }

    protected void btnOK_Click(object sender, System.EventArgs e)
    {
        if (!user.CanInvest)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，您还不是高级会员，请先免费升级为高级会员。谢谢！");
            return;
        }

        if (panelInvestPassword.Visible)
        {
            if (tbInvestPassword.Text != user.Password_2)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "投注密码错误！");
                return;
            }
        }

        DateTime EndTime = DateTime.Parse(labEndTime.Text);
        if (DateTime.Now > EndTime)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "投注时间已经截止，不能认购。");
            return;
        }

        double ShareMoney = 0;
        int Share = 0;

        try
        {
            ShareMoney = double.Parse(labShareMoney.Text);
            Share = int.Parse(tbShare.Text);
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        if ((ShareMoney <= 0) || (Share < 1) || (Share > ShoveEL._Convert.StrToInt(labShare.Text, 0)))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入有错误，请仔细检查。");
            return;
        }

        string Return = "";
        user.GetUserBalance(ref Return);
        if ((ShareMoney * Share) > user.Balance)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "您的帐户余额不足，请先增加预付款，谢谢。");
            return;
        }

        Return = "";
        int Result = user.Buy(int.Parse(tbScheme_id.Text), Share, ref Return);
        if ((Return != "") || (Result != 0))
        {
            PublicFunction.GoError(Return);
            return;
        }

        BindData();

        tbShare.Text = "";
        ShoveEL._Web.JavaScript.Alert(this.Page, "您已成功参与合买方案，预祝您早中大奖！");
    }

    protected void btnQuashScheme_Click(object sender, System.EventArgs e)
    {
        if (!user.CanInvest)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "对不起，您还不是高级会员，请先免费升级为高级会员。谢谢！");
            return;
        }

        if (panelInvestPassword.Visible)
        {
            if (tbInvestPassword.Text != user.Password_2)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "投注密码错误！");
                return;
            }
        }

        DateTime EndTime = DateTime.Parse(labEndTime.Text);
        if (DateTime.Now > EndTime)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "投注时间已经截止，不能撤消方案。");
            return;
        }

        string Return = "";
        int Result = user.QuashScheme(int.Parse(tbScheme_id.Text), false, ref Return);
        if ((Return != "") || (Result != 0))
        {
            PublicFunction.GoError(Return);
            return;
        }

        BindData();
    }

    protected void cbAtTopApplication_CheckedChanged(object sender, System.EventArgs e)
    {
        int AtTopApplication = cbAtTopApplication.Checked ? 1 : 0;

        if (MSSQL.ExecuteNonQuery("update Scheme set AtTopApplication = " + AtTopApplication.ToString() + " where [id] = " + tbScheme_id.Text) < 0)
        {
            PublicFunction.GoError();
            return;
        }

        BindData();
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
    {
        if (e.CommandName == "QuashBuy")
        {
            int Buy_id = ShoveEL._Convert.StrToInt(e.Item.Cells[12].Text, 0);
            if (Buy_id < 1)
            {
                PublicFunction.GoError();
                return;
            }

            string Return = "";
            int Result = user.Quash(Buy_id, ref Return);
            if ((Return != "") || (Result != 0))
            {
                PublicFunction.GoError(Return);
                return;
            }

            BindData();
            return;
        }
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Cells[0].Text = "<font color='red'>" + e.Item.Cells[0].Text + "</font> 份";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[1].Text, 0);
            e.Item.Cells[1].Text = "<font color='red'>" + ((money == 0) ? "0.00" : money.ToString("N")) + "</font> 元";

            e.Item.Cells[2].Text = e.Item.Cells[8].Text + e.Item.Cells[9].Text + e.Item.Cells[12].Text;

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[6].Text, false);
            bool Buyed = ShoveEL._Convert.StrToBool(e.Item.Cells[7].Text, false);
            bool Stop = ShoveEL._Convert.StrToBool(tbStop.Text, false);
            double Schedule = ShoveEL._Convert.StrToDouble(e.Item.Cells[11].Text, 0);
            bool CanQuash = ShoveEL._Convert.StrToBool(e.Item.Cells[10].Text, false);

            if (Quashed)
                e.Item.Cells[4].Text = "已撤单";
            else
            {
                if (Stop)
                {
                    if (Schedule >= 100)
                        e.Item.Cells[4].Text = "<Font color=\'Red\'>已成功</font>";
                    else
                        e.Item.Cells[4].Text = "未成功";
                }
                else
                {
                    if (Buyed)
                        e.Item.Cells[4].Text = "<Font color=\'Red\'>已出票</font>";
                    else
                        e.Item.Cells[4].Text = "<Font color=\'Red\'>进行中</font>";
                    if (CanQuash)
                        ((Button)e.Item.Cells[5].FindControl("btnQuashBuy")).Enabled = (user.UserType == 2);
                }
            }
        }
    }
}