﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Score : System.Web.UI.Page
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        int User_id = -1;
        try
        {
            User_id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
        }
        catch { }

        if (User_id < 1)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        int Lottery_id = -1;
        try
        {
            Lottery_id = ShoveEL._Convert.StrToInt(this.Request["LotteryType"], -1);
        }
        catch { }

        if (!new Lottery().ValidID(Lottery_id))
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        if (!this.IsPostBack)
            BindData(User_id, Lottery_id);
    }

    private void BindData(int User_id, int Lottery_id)
    {
        Users tu = new Users();
        tu.ID = User_id;
        if (tu.GetUserInfoByID() != 0)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        labUserName.Text = tu.Name;
        labUserRegisterTime.Text = tu.RegisterTime.ToString();
        labUserType.Text = (tu.UserType == 1 ? "普通会员" : "高级会员");

        DataTable dt = DAL.Tables.Lottery.Select("", "[id] = " + Lottery_id.ToString(), "");

        if ((dt == null) || (dt.Rows.Count < 1))
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        labLotteryName.Text = dt.Rows[0]["Name"].ToString();

        dt = DAL.Views.V_SchemeScheduleWithQuashed.Select("", "InitiateUser_id = " + User_id.ToString() + " and Lottery_id = " + Lottery_id.ToString() + " and SystemEndTime < GetDate()", "SystemEndTime desc");

        if (dt == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Cells[1].Text = "<a href='Scheme.aspx?id=" + e.Item.Cells[10].Text + "' target='_blank'><font color=\"#330099\">" + e.Item.Cells[1].Text + "</Font></a>";

            string str = e.Item.Cells[3].Text;
            if (str.Length > 25)
                str = str.Substring(0, 23) + "..";
            e.Item.Cells[3].Text = str;

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[4].Text, 0);
            e.Item.Cells[4].Text = (money == 0) ? "" : money.ToString("N");

            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[5].Text, 0);
            e.Item.Cells[5].Text = (money == 0) ? "" : money.ToString("N");

            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[7].Text, false);
            bool LotteryBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[8].Text, false);
            int Schedule = ShoveEL._Convert.StrToInt(e.Item.Cells[9].Text, 0);

            if (LotteryBuyed)
                e.Item.Cells[6].Text = "<font color='red'>已成功</font>";
            else
            {
                if (Quashed)
                    e.Item.Cells[6].Text = "未成功";
                else
                {
                    if (Schedule < 100)
                        e.Item.Cells[6].Text = "未成功";
                    else
                        e.Item.Cells[6].Text = "<font color='blue'>未录入</font>";
                }
            }
        }
    }
}