﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

/// <summary>
///		WinAffiche 的摘要说明。
/// </summary>
public partial class WinAffiche : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindData();
        }
    }

    private void BindData()
    {
        DataTable dt = MSSQL.Select("select top 50 id, [Name], Isuse, WinDescription from V_Scheme where AtWinAffiche = 1 and LotteryBuyed = 1 and WinMoney > 0 order by WinMoney desc");

        if (dt == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        dt.Columns.Add("WinDescription2", System.Type.GetType("System.String"));
        foreach (DataRow dr in dt.Rows)
        {
            string str = "";
            try
            {
                str = dr["Name"].ToString() + dr["Isuse"].ToString() + ShoveEL._String.Decompress((byte[])dr["WinDescription"]);
            }
            catch
            {
                str = "&nbsp;&nbsp;";
            }

            if (str.Length > 19)
                str = str.Substring(0, 17) + "..";

            dr["WinDescription2"] = str;
            dt.AcceptChanges();
        }

        g.DataSource = dt;
        g.DataBind();
    }
}