﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class WinAfficheDetail : System.Web.UI.Page
{
    public string Name = "", Isuse = "", Type = "", InitiateUser = "", Money = "", WinDescription = "";

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (id < 1)
            {
                this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
                return;
            }
            BindData(id);
        }
    }

    private void BindData(int id)
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        SqlCommand Cmd = new SqlCommand("select * from V_Scheme where AtWinAffiche = 1 and id = " + id.ToString(), conn);
        SqlDataReader dr = null;
        try
        {
            dr = Cmd.ExecuteReader();
        }
        catch
        {
            conn.Close();
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        if (!dr.Read())
        {
            dr.Close();
            conn.Close();
            this.Response.Redirect("Error.aspx?ErrorNumber=01", true);
            return;
        }

        Name = dr["Name"].ToString();
        Isuse = dr["Isuse"].ToString();
        Type = dr["Type"].ToString();
        InitiateUser = dr["InitiateUser"].ToString();
        Money = ShoveEL._Convert.StrToDouble(dr["Money"].ToString(), 0).ToString("N") + "元";
        try
        {
            WinDescription = ShoveEL._String.Decompress((byte[])dr["WinDescription"]);
        }
        catch
        {
            WinDescription = "";
        }
        WinDescription += "(" + dr["Multiple"].ToString() + "倍)。奖金：" + ShoveEL._Convert.StrToDouble(dr["WinMoney"].ToString(), 0).ToString("N") + "元，税后奖金：" + ShoveEL._Convert.StrToDouble(dr["WinMoneyNoWithTax"].ToString(), 0).ToString("N") + "元。";

        string LotteryCode = "";
        try
        {
            LotteryCode = ShoveEL._String.Decompress((byte[])dr["LotteryCode"]);
        }
        catch
        { }
        dr.Close();
        conn.Close();

        string[] LotteryImage = LotteryCode.Split(',');
        if (LotteryImage.Length < 1)
            return;

        string Image = "";
        for (int i = 0; i < LotteryImage.Length; i++)
        {
            if (LotteryImage[i].Trim() != "")
                Image += "<img alt='" + LotteryImage[i].Trim() + "彩票图片尚未上传' src='images/Lottery/Win/" + LotteryImage[i] + ".jpg' border='0'><br><BR>";
        }

        labLotteryImage.Text = Image;
    }
}