﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class WinNameList : System.Web.UI.UserControl
{
    public string UserID, Isuse, Money, Say;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (PublicFunction.GetVersion() != "1")
        {
            this.Visible = false;
            return;
        }

        BindData();
    }

    private void BindData()
    {
        DataSet ds = DAL.Procedures.P_GetWinNameList.Open();
        if ((ds == null) || (ds.Tables.Count < 1))
        {
            PublicFunction.GoError();
            return;
        }

        ds.Tables[0].Columns.Add("WinMoney2", System.Type.GetType("System.String"));
        ds.Tables[0].Columns.Add("Say2", System.Type.GetType("System.String"));
        foreach (DataRow dr in ds.Tables[0].Rows)
        {
            string Say = "";
            try
            {
                Say = ShoveEL._String.Decompress((byte[])dr["Say"]);
            }
            catch { }

            if (Say.Length > 11)
                Say = Say.Substring(0, 9) + "..";

            dr["Say2"] = Say;
            dr["WinMoney2"] = ShoveEL._Convert.StrToDouble(dr["WinMoney"].ToString(), 0).ToString("N");

            ds.Tables[0].AcceptChanges();
        }

        g.DataSource = ds.Tables[0];
        g.DataBind();
    }
}