 /*
  * Infragistics WebGauge CSOM Script: ig_webGauge.js
  * Version 7.1.20071.40
  * Copyright(c) 2001-2006 Infragistics, Inc. All Rights Reserved.
  */


function ig_getWebGaugeById(id)
{
    return ig_getWebControlById(id);
}
function ig_WebGauge(prop)
{
    this._initProp(prop);
}
function ig_CreateWebGauge(prop)
{
    if (!ig_WebControl.prototype.isPrototypeOf(ig_WebGauge.prototype))
    {
        ig_WebGauge.prototype = new ig_WebControl();
        ig_WebGauge.prototype.constructor = ig_WebGauge;
        ig_WebGauge.prototype.base = ig_WebControl.prototype;
        ig_WebGauge.prototype._initProp = function(prop)
        {
            if (!prop)
            {
                return;
            }
            this._is1st = true;
            this._initControlProps(prop);
            var id = this._clientID;
            this.init(id);
            this._element = ig_csom.getElementById(id);
            if (!this._element)
            {
                return;
            }
           	ig_shared.addEventListener(this._element, "click", ig_handleEvent);
            ig_shared.addEventListener(this._element, "dblclick", ig_handleEvent);
            this.fireEvent("initialize");
        }
        ig_WebGauge.prototype.refresh = function()
        {
            var clientContext = {operation: "Refresh"};
            var serverContext = clientContext;
            var smartCallback = new ig_SmartCallback(clientContext, serverContext, null, this._uniqueID, this);
            smartCallback.execute();
        }
        ig_WebGauge.prototype.callbackRender = function(response, context)
        {
            var props = eval(response.replace(/\^/g, "\""));
            this._decodeProps(props);
            if (typeof(Image) != "undefined")
            {
                this.bufferImage = new Image();
                this.bufferImage.gauge = this;
                this.bufferImage.src = props[0];
                if (typeof(this.bufferImage.onreadystatechange) != "undefined")
                {
                    this.bufferImage.onreadystatechange = _igGauge_loadBufferImage;
                }
                else 
                {
                    ig_shared.addEventListener(this.bufferImage, "load", _igGauge_loadBufferImage);
                }
            }
            else
            {
                this.getElement().src = props[0];
            }
        }
    }
    return new ig_WebGauge(prop);   
}
function _igGauge_loadBufferImage(e)
{
    var complete, bufferImageElement, eventType;
    if (e && (eventType = e.type) == "load")
    {
        bufferImageElement = e.currentTarget;
        complete = e.currentTarget.complete;
    }
    else // if (window.event && window.event.type == "readystatechange")
    {
        eventType = window.event.type;
        bufferImageElement = this; 
        complete = this.readyState == "complete";
    }
    var gauge = bufferImageElement.gauge;
    if (complete)
    {
        gauge.getElement().src = bufferImageElement.src;
        ig_shared.removeEventListener(bufferImageElement, eventType, _igGauge_loadBufferImage);
        gauge.bufferImage = null;
    }
}
