<?php
//申明全局变量-设置选项
global $ashu_option;

//定义主内容宽度
if ( ! isset( $content_width ) )
	$content_width = 680;

/*******定义路径常量**********/
define('TEMINCLUDE', get_template_directory() . '/include/');
define('WIDGETPATH', get_template_directory() . '/widgets/');
define('OPTIONPATH', get_template_directory() .'/options/');
define('THEMEUSER', get_template_directory() .'/user/');

/*****************定义url常量*******************/
define('THEME_URI', get_template_directory_uri() . '/');
define('TEMINCLUDE_URI', get_template_directory_uri() . '/include/');
define('OPTIONS_URI', 	get_template_directory_uri() . '/options/'); 
define('TEMJS_URI', THEME_URI .'js/');

/***************加载文件*****************/
include_once(TEMINCLUDE .'metaboxclass.php');
include_once(TEMINCLUDE .'metabox.php');
include_once(TEMINCLUDE .'function.php');
include_once(TEMINCLUDE .'class-taxonomy-feild.php');
include_once(TEMINCLUDE .'simple-term-meta.php');
//include_once(TEMINCLUDE .'img_resize.php');
include_once(TEMINCLUDE .'post_type.php');
include_once(TEMINCLUDE .'ajax.php');
include_once(TEMINCLUDE .'breadcrumbs.php');
include_once(TEMINCLUDE .'custom-register.php');

include_once(OPTIONPATH .'optionclass.php');
include_once(OPTIONPATH .'general.php');
include_once(OPTIONPATH .'options.php');
include_once(OPTIONPATH .'malltype.php');

include_once(WIDGETPATH .'twoads.php');
include_once(WIDGETPATH .'ninesquare.php');
include_once(WIDGETPATH .'hotpost.php');

include_once(THEMEUSER .'user-avatar.php');

//添加缩略图支持
if ( function_exists( 'add_theme_support' ) ) {
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'sidebar-post-thumbnail', 245, 245, true ); //侧边栏
}

//去除头部多余信息
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'index_rel_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'start_post_rel_link', 10, 0);
remove_action('wp_head', 'parent_post_rel_link', 10, 0);
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);
remove_filter('the_content', 'wptexturize');

//为编辑器增加按钮
function add_more_buttons($buttons) {
$buttons[] = 'hr'; 
$buttons[] = 'sub'; 
$buttons[] = 'sup'; 
$buttons[] = 'fontselect'; 
$buttons[] = 'fontsizeselect'; 
$buttons[] = 'cleanup'; 
$buttons[] = 'styleselect'; 
return $buttons; 
}
add_filter("mce_buttons_3", "add_more_buttons");

//注册菜单
if( function_exists('register_nav_menus') ){
	register_nav_menus(
		array(
			'ashu-menu' => '主导航菜单',
			'left-menu' => '左侧悬挂菜单',
			'hot-menu' => '热门活动菜单',
		)
	);
}

//注册小工具
function AshuWidgetRegister(){
	//注册侧边栏
	if ( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'name' => '侧边栏',
		'description' => '文章详细页面侧边栏',
		'before_widget' => '<div id="%1$s" class="rightBox %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<div class="titleStyle">',
		'after_title' => '</div>',
	));
	register_sidebar(array(
		'name' => '侧边栏滑动部分',
		'description' => '侧边栏滑动部分，建议只放一两个小工具',
		'id'=>'slider',
		'before_widget' => '<div id="%1$s" class="rightBox %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<div class="titleStyle">',
		'after_title' => '</div>',
	));
	register_sidebar(array(
		'name' => '底部区域',
		'id'=>'footer',
		'description' => '站点底部区域',
		'before_widget' => '',
		'after_widget' => '',
		'before_title' => '<div class="footerTitle">',
		'after_title' => '</div>',
	));
	}
	
	register_widget('Onecolumnsads');
	register_widget('NineSquare');
	register_widget('HotPost');
}
add_action('widgets_init','AshuWidgetRegister');

/********添加query变量************/
function smzdm_query_vars($public_query_vars) {
	$public_query_vars[] = 'my_custom_page_type'; 
	$public_query_vars[] = 'step'; 
	$public_query_vars[] = 'my_second_page';
	$public_query_vars[] = 'third_page';
	$public_query_vars[] = 'username';
	$public_query_vars[] = 'pid';
	$public_query_vars[] = 'post_id';
	$public_query_vars[] = 'mallid';
	
	return $public_query_vars;  
}
/********锁定后台****/
function redirect_user_login() {
	global $current_user,$pagenow;
	get_currentuserinfo();
	$valid_pages = array('admin-ajax.php', 'async-upload.php', 'media-upload.php');
	if( !current_user_can('administrator') && !in_array( $pagenow, $valid_pages ) ){
		wp_redirect( smzdm_my_account_link() ); exit;
	}
}
add_action('admin_init','redirect_user_login');

function smzdm_my_account_link(){
	return site_url()."/my-account";		
}
function smzdm_post_new_link(){
	return site_url()."/post-new";		
}

/************重写规则*************/
function smzdm_rewrite_rules( $wp_rewrite ){
$new_rules = array(
'go/?([0-9]{1,})/?$' => 'index.php?my_custom_page_type=go_page&pid='.$wp_rewrite->preg_index(1),
'go_mall/?([0-9]{1,})/?$' => 'index.php?my_custom_page_type=go_mall&mallid='.$wp_rewrite->preg_index(1),
'user-profile/([^/]+)/?$' => 'index.php?my_custom_page_type=user_profile&username='.$wp_rewrite->preg_index(1),
'user-profile/([^/]+)/page/?([0-9]{1,})/?$' => 'index.php?my_custom_page_type=user_profile&username='.$wp_rewrite->preg_index(1).'&paged='.$wp_rewrite->preg_index(2),
'post_new/?$' => 'index.php?my_custom_page_type=post_new'.$wp_rewrite->preg_index(1),
'post-new?$' => 'index.php?my_custom_page_type=post-new&step='.$wp_rewrite->preg_index(1),
'my-account/?$' => 'index.php?my_custom_page_type=my_account&step=1',
'my-account/([^/]+)/?$' => 'index.php?my_custom_page_type=my_account&paged=1&my_second_page='.$wp_rewrite->preg_index(1),
'my-account/([^/]+)/page/?([0-9]{1,})/?$' => 'index.php?my_custom_page_type=my_account&my_second_page='.$wp_rewrite->preg_index(1).'&paged='.$wp_rewrite->preg_index(2),
'my-account/([^/]+)/my-page/([^/]+)/?$' => 'index.php?my_custom_page_type=my_account&my_second_page='.$wp_rewrite->preg_index(1).'&third_page='.$wp_rewrite->preg_index(2),
'my-account/([^/]+)/?([0-9]{1,})/?$' => 'index.php?my_custom_page_type=my_account&my_second_page='.$wp_rewrite->preg_index(1).'&post_id='.$wp_rewrite->preg_index(2),
);
$wp_rewrite->rules = $new_rules + $wp_rewrite->rules;
}

/************模板载入规则****************/
function smzdm_template_redirect(){
	global $wp,$wp_query,$wp_rewrite;
	if( !isset($wp_query->query_vars['my_custom_page_type']) )
		return;
	$reditect_page =  $wp_query->query_vars['my_custom_page_type'];
	
	if ($reditect_page == "my_account"){
		include(THEMEUSER.'my-account.php');
		die();
	}
	if ($reditect_page == "go_page"){
		include(get_template_directory().'/go.php');
		die();
	}
	if ($reditect_page == "go_mall"){
		include(get_template_directory().'/gomall.php');
		die();
	}

	if ($reditect_page == "user_profile"){
		include(THEMEUSER.'user-profile.php');
		die();
	}
	if ($reditect_page == "post-new"){
		include(THEMEUSER.'page-newpost.php');
		die();
	}
}

/*********更新重写规则***************/
function smzdm_flush_rewrite_rules() {
	global $pagenow, $wp_rewrite;

	if ( 'themes.php' == $pagenow && isset( $_GET['activated'] ) )
		$wp_rewrite->flush_rules();
}
add_action( 'load-themes.php', 'smzdm_flush_rewrite_rules' );

//session_start();
add_action('generate_rewrite_rules', 'smzdm_rewrite_rules' );
add_action('query_vars', 'smzdm_query_vars');  
add_action("template_redirect", 'smzdm_template_redirect');
show_admin_bar(false);

function wp_register_ashu( $before = '<li>', $after = '</li>', $echo = true ) {
	if ( ! is_user_logged_in() ) {
		if ( get_option('users_can_register') )
			$link = $before . '<a class="regBtn" href="' . site_url('wp-login.php?action=register', 'login') . '">' .  '</a>' . $after;
		else
			$link = '';
	} else {
		$link = $before . '<a   class="regBtn" href="' . admin_url() . '">' . '</a>' . $after;
	}
	if ( $echo )
		echo apply_filters('register', $link);
	else
		return apply_filters('register', $link);
}

add_filter('the_content','ashu_fist_paragraph');
function ashu_fist_paragraph($content){
	if( is_home() || is_category() ){
		$content = preg_replace('/<p([^>]+)?>/', '<p$1 class="p_detail">', $content, -1);
		$content = preg_replace('/<p(.*?)([^>]+)?>/', '<p$1 class="p_excerpt">', $content, 1);
		return $content;

	}else{
		return $content;
	}
	return $content;
}