<!DOCTYPE HTML>
<html lang="zh-CN">
<head>
<?php global $ashu_option; ?>
<meta name="author" content="树是我的朋友" />
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php
	global $page, $paged;
	wp_title( '|', true, 'right' );
	bloginfo( 'name' );
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( '页面 %s', max( $paged, $page ) );
	?>
</title>
<?php include("seo.php");?>
<meta name="keywords" content="<?php echo $keywords; ?>" />
<meta name="description" content="<?php echo $description; ?>" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('stylesheet_url'); ?>"/>
<link rel="icon" href="<?php echo $ashu_option['general']['home_icon'];?>" type="image/x-icon" />
<?php wp_head();?>
</head>
<body >

<!--s header-->
<header>
<div class="header_top_parent">
    <div class="header_top" id="header_top">
        <div class="wrap">
            <div class="topLogo lfloat">
			<?php $menu_logo = (isset($ashu_option['general']['menu_logo']) && $ashu_option['general']['menu_logo'] != '') ? $ashu_option['general']['menu_logo'] : get_template_directory_uri().'/images/menu_logo.png'; ?>
			<img src="<?php echo $menu_logo;?>" alt="<?php bloginfo('name');?>" width="130" height="38"/>
			<a href="<?php bloginfo('home');?>"><?php bloginfo('name');?></a>
			</div>
			<div class="login" id='nologin'>
				<?php
				if(!is_user_logged_in()) {
				?>
					<?php wp_register_ashu('',''); ?>
					<div class="loginBtn"> <a href="<?php echo wp_login_url(); ?> " class="loginButton">登录</a>
					</div>
				<?php } ?>
				
            </div>
            <div class="menu_top">
			<?php if(is_user_logged_in()) { ?>
				<ul class="header_nav1_class" id="header_nav1">
				<?php get_currentuserinfo();
				global $current_user,$userdata;
				get_currentuserinfo();
				?>
				<li><a href="<?php echo smzdm_my_account_link(); ?>">会员中心</a></li>
				<li><a href="<?php echo wp_logout_url( home_url() ); ?>">注销登录</a></li>
				<li>欢迎您<?php echo esc_attr( $userdata->user_login ); ?></li>
				</ul>
			<?php } ?>
			</div>
            <div class="clear"></div>
        </div>
    </div>
</div>
    <div class="wrap">
        <div class="logo">
		<?php $home_logo = (isset($ashu_option['general']['home_logo']) && $ashu_option['general']['home_logo'] != '') ? $ashu_option['general']['home_logo'] : get_template_directory_uri().'/images/home_logo.png'; ?>
		<img src="<?php echo $home_logo;?>" alt="<?php bloginfo('name');?>" width="70" height="50"/>
		<a href="<?php echo home_url('/');?>"><?php bloginfo('description'); ?></a></div>
        <div class="topAd">
        	<div class="not_left_ce">
				<span class="not_a1" onMouseOut="gstart()" onMouseOver="gstop()" style="cursor:pointer;" onClick="goup()"><img src="<?php echo get_template_directory_uri();?>/images/notice_left.png" /></span>
				<span class="not_a2" onMouseOut="gstart()" onMouseOver="gstop()" style="cursor:pointer;" onClick="godown()"><img src="<?php echo get_template_directory_uri();?>/images/notice_right.png" /></span>
			</div>
			<div id="news">
			<?php
			$args = array(
				'post_type'=>'notice',
				'showposts'=>5
			);
			query_posts( $args );
			if( have_posts() ) : ?>
			<ul id='topAd' onMouseOut="gstart()" onMouseOver="gstop()">
			<?php while( have_posts() ) : the_post(); ?>
			<li><a href="<?php the_permalink(); ?>"><?php the_title();?></a></li>
			<?php endwhile;?>
			</ul>
			<?php endif; wp_reset_query(); ?>
			</div>
        </div>
        <div class="clear"></div>
        <nav>
            <div class="navBox" id="navbar">
                <div class="nav">
					<?php
					$args = array(
						'echo' => true,
						'container' => false,
						'sort_column' => 'menu_order',
						'menu_id'=>'nav_id',
						'depth'=>2,
						'menu_class'=>'nav_class',
						'walker' => new SH_Last_Walker(),
						'theme_location' => 'ashu-menu',
					);
					wp_nav_menu($args);
					?>
					<?php get_search_form();?>
				</div>
                <div class="clear"></div>
            </div>
        </nav>
    </div>
</header>