<?php
/************用户设置页面**************/
if(!is_user_logged_in()) {
	wp_redirect(site_url()."/wp-login.php");
	exit;
}

global $userdata, $wp_http_referer;
get_currentuserinfo();
if ( !(function_exists( 'get_user_to_edit' )) ) {
	require_once(ABSPATH . '/wp-admin/includes/user.php');
}
if ( !(function_exists( '_wp_get_user_contactmethods' )) ) {
	require_once(ABSPATH . '/wp-includes/registration.php');
}
$current_user = wp_get_current_user();
$user_id = $current_user->ID;

if ( isset( $_POST['submit'] ) ) {
	check_admin_referer( 'update-profile_' . $user_id );
	$errors = edit_user( $user_id );
	if ( is_wp_error( $errors ) ) {
		$message = $errors->get_error_message();
		$style = 'error';
	} else {
		$message = '资料已更新';
		$style = 'success';
		do_action( 'personal_options_update', $user_id );
	}
}
$profileuser = get_user_to_edit( $user_id );
if ( isset( $message ) ) {
	echo '<div class="' . $style . '">' . $message . '</div>';
}
?>
<?php
wp_enqueue_script('thickbox');
wp_enqueue_style('thickbox');
?>
<div class="wpuf-profile">
	<fieldset>
	<?php user_avatar_form($current_user);?>
	</fieldset>
	<form name="profile" id="your-profile" action="" method="post">
		<?php wp_nonce_field( 'update-profile_' . $user_id ) ?>
		<?php if ( $wp_http_referer ) : ?>
			<input type="hidden" name="wp_http_referer" value="<?php echo esc_url( $wp_http_referer ); ?>" />
		<?php endif; ?>
		<input type="hidden" name="from" value="profile" />
		<input type="hidden" name="checkuser_id" value="<?php echo $user_id; ?>" />
		<table class="wpuf-table">
			<?php do_action( 'personal_options', $profileuser ); ?>
		</table>
			<?php do_action( 'profile_personal_options', $profileuser ); ?>
		<fieldset>
			<legend>名字</legend>
			<table class="wpuf-table">
			<tr>
				<th><label for="user_login1">用户名</label></th>
				<td><input type="text" name="user_login" id="user_login1" value="<?php echo esc_attr( $profileuser->user_login ); ?>" disabled="disabled" class="regular-text" /><br /><em><span class="description">用户名不可修改</span></em></td>
			</tr>
			<tr>
				<th><label for="first_name">姓氏</label></th>
				<td><input type="text" name="first_name" id="first_name" value="<?php echo esc_attr( $profileuser->first_name ) ?>" class="regular-text" /></td>
			</tr>
			<tr>
				<th><label for="last_name">名字</label></th>
				<td><input type="text" name="last_name" id="last_name" value="<?php echo esc_attr( $profileuser->last_name ) ?>" class="regular-text" /></td>
			</tr>
			<tr>
				<th><label for="nickname">昵称<span class="description">(必需)</span></label></th>
				<td><input type="text" name="nickname" id="nickname" value="<?php echo esc_attr( $profileuser->nickname ) ?>" class="regular-text" /></td>
			</tr>
			<tr>
				<th><label for="display_name">公开显示为</label></th>
				<td>
					<select name="display_name" id="display_name">
					<?php
						$public_display = array();
						$public_display['display_username'] = $profileuser->user_login;
						$public_display['display_nickname'] = $profileuser->nickname;
						if ( !empty( $profileuser->first_name ) )
							$public_display['display_firstname'] = $profileuser->first_name;
						if ( !empty( $profileuser->last_name ) )
							$public_display['display_lastname'] = $profileuser->last_name;
						if ( !empty( $profileuser->first_name ) && !empty( $profileuser->last_name ) ) {
							$public_display['display_firstlast'] = $profileuser->first_name . ' ' . $profileuser->last_name;
							$public_display['display_lastfirst'] = $profileuser->last_name . ' ' . $profileuser->first_name;
						}
						if ( !in_array( $profileuser->display_name, $public_display ) ) // Only add this if it isn't duplicated elsewhere
							$public_display = array('display_displayname' => $profileuser->display_name) + $public_display;
						$public_display = array_map( 'trim', $public_display );
						$public_display = array_unique( $public_display );
						foreach ($public_display as $id => $item) { ?>
							<option id="<?php echo $id; ?>" value="<?php echo esc_attr( $item ); ?>"<?php selected( $profileuser->display_name, $item ); ?>><?php echo $item; ?></option>
						<?php } ?>
					</select>
				</td>
			</tr>
			</table>
		</fieldset>
		<fieldset>
			<legend>联系信息</legend>
			<table class="wpuf-table">
			<tr>
				<th><label for="email">E-mail<span class="description">必须</span></label></th>
				<td><input type="text" name="email" id="email" value="<?php echo esc_attr( $profileuser->user_email ) ?>" class="regular-text" /> </td>
			</tr>
			<tr>
				<th><label for="url">网站</label></th>
				<td><input type="text" name="url" id="url" value="<?php echo esc_attr( $profileuser->user_url ) ?>" class="regular-text code" /></td>
			</tr>
			<?php foreach (_wp_get_user_contactmethods() as $name => $desc) { ?>
			<tr>
				<th><label for="<?php echo $name; ?>"><?php echo apply_filters( 'user_' . $name . '_label', $desc ); ?></label></th>
				<td><input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="<?php echo esc_attr( $profileuser->$name ) ?>" class="regular-text" /></td>
			</tr>
			<?php } ?>
			</table>
		</fieldset>
		<fieldset>
			<legend>关于你自己</legend>
			<table class="wpuf-table">
			<tr>
				<th><label for="description"><?php _e( 'Biographical Info', 'wpuf' ); ?></label></th>
				<td><textarea name="description" id="description" rows="5" cols="30"><?php echo esc_html( $profileuser->description ); ?></textarea><br />
					<span class="description"><?php _e( 'Share a little biographical information to fill out your profile. This may be shown publicly.' ); ?></span>
				</td>
			</tr>
			<tr id="password">
				<th><label for="pass1">新密码</label></th>
				<td>
					<input type="password" name="pass1" id="pass1" size="16" value="" autocomplete="off" /><br /><br />
				</td>
			</tr>
			<tr>
				<th><label>确认密码</label></th>
				<td>
					<input type="password" name="pass2" id="pass2" size="16" value="" autocomplete="off" />&nbsp;<em><span class="description">再次输入密码</span></em>
				</td>
			</tr>
			</table>
		</fieldset>
		<p class="submit">
			<input type="hidden" name="action" value="update" />
			<input type="hidden" name="user_id" id="user_id" value="<?php echo esc_attr( $user_id ); ?>" />
			<input type="submit" class="wpuf-submit" value="更新资料" name="submit" />
		</p>
	</form>
</div>