<?php
/**************************************/
/***************给分类法添加自定义字段类文件************************/
/*****************源码下载：源码库 www.cnymk.com*************************/
class ashu_taxonomy_feild{
	var $options;
	var $taxonomyinfo;
	
	function ashu_taxonomy_feild($options,$taxonomyinfo){
		$this->options = $options;
		$this->taxonomyinfo = $taxonomyinfo;
		
		foreach($this->taxonomyinfo as $taxonomy){
				add_action($taxonomy.'_add_form_fields', array(&$this, 'taxonomy_fields_adds'), 10, 2);
				add_action($taxonomy.'_edit_form_fields', array(&$this, 'taxonomy_metabox_edit'), 10, 2);
				add_action('created_'.$taxonomy, array(&$this, 'save_taxonomy_metadata'), 10, 1);	
				add_action('edited_'.$taxonomy,array(&$this, 'save_taxonomy_metadata'), 10, 1);
				add_action('admin_menu', array(&$this, 'init_taxonomy'));
		}
	}
	
	function init_taxonomy(){
		if(basename( $_SERVER['PHP_SELF']) == "edit-tags.php") {
			//注意加载的脚本的url
			wp_enqueue_style('cate_fields_css', TEMJS_URI. 'cate_fields.css');
			wp_enqueue_script('cate_fields_js',TEMJS_URI. 'cate_fields.js');
			wp_enqueue_script('thickbox');
			wp_enqueue_style('thickbox');
		}
	}
	/*********添加分类页面*******/
	function taxonomy_fields_adds($tag){
		foreach($this->options as $option){
			if( (!isset($option["edit_only"]) || !$option["edit_only"] ) && ($option['type'] != 'tinymce')){
			if (method_exists($this, $option['type'])){
				echo '<div class="form-field">';
				echo '<label for="'.$option['id'].'" >'.$option['name'].'</label>';
				$this->$option['type']($option);
				echo '</div>';
			}
			}
		}
	}
	/*************编辑分类页面*****************/
	function taxonomy_metabox_edit($tag){
		foreach($this->options as $option){
			if (method_exists($this, $option['type'])){
				if(get_term_meta($tag->term_id , $option['id']) !== ""){
					$option['std'] = get_term_meta($tag->term_id,$option['id'], true);
				}
			
				echo '<tr class="form-field">';
				echo '<th scope="row" valign="top">';
				echo '<label for="'.$option['id'].'" >'.$option['name'].'</label>';
				echo '</th>';
				echo '<td>';
				$this->$option['type']($option);
				echo '</td>';
				echo '</tr>';
			}
		}
	}
	/**************保存数据*****************/
	function save_taxonomy_metadata($term_id){
		foreach($this->options as $option){
			
			if(isset($_POST[$option['id']])){
				if(!current_user_can('manage_categories')){
					return $term_id ;
				}
				//$data = htmlspecialchars($_POST[$option['id']], ENT_QUOTES,"UTF-8");
				$data = $_POST[$option['id']];
				if(get_term_meta($term_id , $option['id']) == "")
					add_term_meta($term_id , $option['id'], $data, true);
				elseif($data != get_term_meta($term_id , $option['id'], true))
					update_term_meta($term_id , $option['id'], $data);
				elseif($data == "")
					delete_term_meta($term_id , $option['id'], get_term_meta($term_id , $option['id'], true));
				
			}
		}
	}
	
	/******提示信息******/
	function info($option){
		echo '<p>'.$option['desc'].'</p>';
	}
	
	/*******文本输入框text*******/
	function text($option){
			echo '<input type="text" size="'.$option['size'].'" value="';
			echo $option['std'];
			echo '" id="'.$option['id'].'" name="'.$option['id'].'"/>';
			echo '<p>'.$option['desc'].'</p>';
	}
	
	/******文本域***********/
	function textarea($option){
		echo '<textarea cols="40" rows="5" id="'.$option['id'].'" name="'.$option['id'].'">'.$option['std'].'</textarea>';
		echo '<p>'.$option['desc'].'</p>';
	}
	
	
	/**********单选框************/
	function radio( $option ){
		foreach( $option['buttons'] as $key=>$value ) {
			$checked ="";
			if( $option['std'] == $key) {
				$checked = 'checked = "checked"';
			}
			echo '<input '.$checked.' type="radio" class="kcheck" value="'.$key.'" name="'.$option['id'].'"/>'.$value;
		}
	}
	
	/***********下拉选择***********/
	function dropdown($option){
		echo '<select class="postform" id="'. $option['id'] .'" name="'. $option['id'] .'"> ';
			echo '<option value="">请选择...</option>  ';
			
			foreach ($option['subtype'] as $key => $entry){
				$selected='';
				if( $option['std'] == $key ){
					$selected = "selected='selected'";
				}
				echo"<option $selected value='". $key."'>". $entry."</option>";
			}
		echo '</select>';
		echo '<p>'.$option['desc'].'</p>';
	}
	
	function malltype($option){
		global $ashu_option;
		$count=(int)$ashu_option['malltype']['malltype_count'];
		$mall_type = array();
		for($i=0;$i<$count;$i++){
			if( $ashu_option['malltype']['malltype_name_'.$i] != '' ){
				$key = $ashu_option['malltype']['malltype_name_'.$i];
				$value = $ashu_option['malltype']['malltype_title_'.$i];
				$mall_type[$key]=$value;
			}
		}
		
		echo '<select class="postform" id="'. $option['id'] .'" name="'. $option['id'] .'"> ';
			echo '<option value="">请选择...</option>  ';
			
			foreach ($mall_type as $key => $entry){
				$selected='';
				if( $option['std'] == $key ){
					$selected = "selected='selected'";
				}
				echo"<option $selected value='". $key."'>". $entry."</option>";
			}
		echo '</select>';
		echo '<p>'.$option['desc'].'</p>';
	}
	
	/***************图片上传**********************/
	function upload($option){
		$prevImg = '';

		if($option['std'] != ''){$prevImg = '<img src='.$option['std'].' alt="" />';}
		
		echo '<div class="preview_pic_optionspage" id="'.$option['id'].'_div">'.$prevImg.'</div>';
		echo $option['desc'].'<br/>';
		echo '<input type="text" size="60" value="'.$option['std'].'" name="'.$option['id'].'" class="upload_pic_input" />';
		echo '&nbsp;<a onclick="return false;" title="" class="cat_up button thickbox" id="'.$option['id'].'" href="media-upload.php?type=image&amp;TB_iframe=true">Insert Image</a>';
	}
	
	/*******************编辑器****************************/
	function tinymce($option){
		wp_editor( $option['std'], $option['id'],$settings=array('quicktags'=>0,'tinymce'=>1) );
	}
}

$options = array();
$taxonomyinfo = array('category','mall','shop');
$options[] = array(	"name" => "分类关键词",
			"desc" => "",
			"id" => "_seo_keywords",
			"std" => "",
			"edit_only"=>false,
			"size" => 40,
			"type" => "text");

$new_taxonomy_feild = new ashu_taxonomy_feild($options, $taxonomyinfo);

$mall_options = array();
$mall_info = array('mall');

$mall_options[] = array(
	"name" => "商家类别",
	"desc" => "",
	"id" => "_mall_type",
	"std" => "zhsc",
	"edit_only"=>false,
	"type" => "malltype"
	);

$mall_options[] = array(
	"name" => "推荐指数",
	"desc" => "",
	"id" => "_mall_args",
	"std" => '5',
	"edit_only"=>false,
	"buttons" => array('1'=>'一颗星','2'=>'二颗星','3'=>'三颗星','4'=>'四颗星','5'=>'五颗星'),
	"type" => "radio"
	);

$mall_options[] = array(
	"name" => "商城首页",
	"desc" => "",
	"id" => "_mall_home",
	"std" => '',
	"size" => 40,
	"type" => "text"
	);
	
$mall_options[] = array(
	"name" => "商城跳转地址",
	"desc" => "",
	"id" => "_mall_link",
	"std" => '',
	"size" => 40,
	"type" => "text"
	);
	
$mall_options[] = array(
	"name" => "商城图片",
	"desc" => "请上传一个商城图片，大小建议180*180",
	"id" => "_mall_icon",
	"std" => '',
	"size" => 40,
	"type" => "upload"
	);
	
$mall_options[] = array(
	"name" => "商家介绍",
	"desc" => "",
	"id" => "_mall_desc",
	"std" => "",
	"edit_only"=>true,
	"type" => "tinymce"
	);

$mall_taxonomy_feild = new ashu_taxonomy_feild($mall_options, $mall_info);
?>