<?php
//文章类型
add_action('init', 'ashu_post_type');
add_action('init', 'ashu_post_taxonomy');
function ashu_post_type() {
	/**********爆料*****************/
	$labels = array(
		'name' => '爆料',
		'singular_name' => '爆料',
		'add_new' => '添加',
		'add_new_item' => '添加新爆料',
		'edit_item' => '编辑',
		'new_item' => '新爆料',
		'view_item' => '查看',
		'search_items' => '搜索',
		'menu_name' => '爆料'
	);
	$args = array(
		'labels' => $labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true, 
		'show_in_menu' => true, 
		'query_var' => true,
		'rewrite' => array('slug'=>'details','with_front' => false),
		'capability_type' => 'post',
		'has_archive' => true, 
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array('title','editor','author','thumbnail','excerpt','comments','custom-fields'),
		'map_meta_cap' => true,
	);
	register_post_type('detail',$args);
	
	/**********公告*****************/
	$labels2 = array(
		'name' => '公告',
		'singular_name' => '公告',
		'add_new' => '添加',
		'add_new_item' => '添加新公告',
		'edit_item' => '编辑',
		'new_item' => '新公告',
		'view_item' => '查看',
		'search_items' => '搜索',
		'menu_name' => '公告'
	);
	$args2 = array(
		'labels' => $labels2,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true, 
		'show_in_menu' => true, 
		'query_var' => true,
		'rewrite' => array('slug'=>'notices'),
		'capability_type' => 'post',
		'has_archive' => true, 
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array('title','editor','author','excerpt','comments','custom-fields'),
		'map_meta_cap' => true,
	);
	register_post_type('notice',$args2);
}

function ashu_post_taxonomy() {
	/*************普通商家*****************/
	$labels = array(
		'name' => '商家',
		'singular_name' => '商家',
		'search_items' =>  '搜索' ,
		'popular_items' => '热门' ,
		'all_items' => '所有' ,
		'parent_item' => null,
		'parent_item_colon' => null,
		'edit_item' => '编辑' , 
		'update_item' => '更新' ,
		'add_new_item' => '添加' ,
		'new_item_name' => '商家名称',
		'menu_name' => '商家分类',
	); 

	register_taxonomy(
		'mall',
		array('post'),
		array(
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => 'mall' ),
		)
	);
	
	/*************爆料商家*****************/
	$labels2 = array(
		'name' => '商家',
		'singular_name' => '商家',
		'search_items' =>  '搜索' ,
		'popular_items' => '热门' ,
		'all_items' => '所有' ,
		'parent_item' => null,
		'parent_item_colon' => null,
		'edit_item' => '编辑' , 
		'update_item' => '更新' ,
		'add_new_item' => '添加' ,
		'new_item_name' => '商家名称',
		'menu_name' => '商家分类',
	); 

	register_taxonomy(
		'shop',
		array('detail'),
		array(
			'hierarchical' => true,
			'labels' => $labels2,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => 'shop' ),
		)
	);
	
	/*************爆料标签*****************/
	$labels3 = array(
		'name' => '标签',
		'singular_name' => '标签',
		'search_items' =>  '搜索' ,
		'popular_items' => '热门' ,
		'all_items' => '所有' ,
		'parent_item' => null,
		'parent_item_colon' => null,
		'edit_item' => '编辑' , 
		'update_item' => '更新' ,
		'add_new_item' => '添加' ,
		'new_item_name' => '标签名称',
		'menu_name' => '标签',
	); 

	register_taxonomy(
		'detail_tag',
		'detail',
		array(
			'labels' => $labels3,
			'show_ui' => true,
			'query_var' => true,
			'rewrite' => array( 'slug' => 'details_tag','with_front' => false  ),
		)
	);
}
?>