<?php
//创建自定义文章类型
add_action( 'init', 'create_post_type' );
function create_post_type() {
	register_post_type( 'slider_type',
		array(
			'labels' => array(
				'name' => __( '幻灯片' ),
				'singular_name' => __( '幻灯片' ),
				'add_new' => '添加',
				'add_new_item' => __('添加新幻灯片'),
				'edit_item' => __('编辑幻灯片'),
				'new_item' => __('新幻灯片')
			),
		'public' => true,
		'has_archive' => true,
		'exclude_from_search' => true,
		'menu_position' => 5,
		'supports' => array( 'title'),
		)
	);
}
//添加列
add_filter( 'manage_edit-slider_type_columns', 'slider_type_custom_columns' );

function slider_type_custom_columns( $columns ) {
	$columns = array(
		'cb' => '<input type="checkbox" />',
		'title' => __( '幻灯片名' ),
		//'hascaption' => __( '说明' ),
		'haslink' => __( '链接到' ),
		'thumbnail' => __( '幻灯片预览' ),
		'date' => __( '日期' )
	);
	return $columns;
}

add_action( 'manage_slider_type_posts_custom_column', 'slider_type_manage_custom_columns', 10, 2 );

function slider_type_manage_custom_columns( $column, $post_id ) {
	global $post;
	switch( $column ) {
		case "hascaption":
			if($post->post_content != ""){
				$text_handler = get_the_excerpt();
				echo substr($text_handler, 0, 50).'...';
			} else {echo '----';}
				break;
		case "haslink":
			if(get_post_meta($post->ID, "slider_url_link", true)){
				echo get_post_meta($post->ID, "slider_url_link", true);
			} else {echo '----';}
				break;
		case "thumbnail":
				$ds_thumb = get_post_meta($post->ID, "slider_pic_url", true);; 
				//$ds_image = vt_resize( '',$ds_thumb , 95, 41, true );
				echo '<img src="'.$ds_thumb.'" width="95" height="41" alt="" />';
				break;
		/* Breakout. */
		default :
			break;
	}
}

function slider_type_sort() {
    add_submenu_page('edit.php?post_type=slider_type', '幻灯片排序', '排序幻灯片', 'edit_posts', basename(__FILE__), 'slider_type_sorter');
}
add_action('admin_menu' , 'slider_type_sort');

function slider_type_sorter() {
	$slides = new WP_Query('post_type=slider_type&posts_per_page=-1&orderby=menu_order&order=ASC');
?>
	<div id="wpoldbcg" class="wrap">
	<div class="icon32" id="icon-upload"><br></div>
	<h2>排序幻灯片: <img src="<?php bloginfo('url'); ?>/wp-admin/images/loading.gif" id="loading-animation" /></h2>
	<span>顶端将会第一个显示.</span>
	<ul id="slide-list">
	<?php while ( $slides->have_posts() ) : $slides->the_post(); ?>
		<li id="<?php the_id(); ?>"><h5><?php the_title(); ?></h5><?php echo '<span>通过鼠标拖曳改变幻灯片顺序.</span>'; $ds_thumb = get_post_thumbnail_id(); $ds_image = vt_resize( $ds_thumb,'' , 95, 41, true ); if(get_the_post_thumbnail($post->ID,'thumbnail')){echo '<img src="'.$ds_image[url].'" alt="" class="alignright sortable_column" />';} ?></li>			
	<?php endwhile; ?>
	</div><!-- End div#wrap //-->
<?php
}

function designsentry_slide_print_styles() {
	global $pagenow;
	$pages = array('edit.php');
	if (in_array($pagenow, $pages))
		wp_enqueue_style('sortables', get_bloginfo('template_url').'/js/slider.css');
}
add_action( 'admin_print_styles', 'designsentry_slide_print_styles' );

function designsentry_slide_print_scripts() {
	global $pagenow;
	$pages = array('edit.php');
	if (in_array($pagenow, $pages)) {
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_script('sortables', get_bloginfo('template_url').'/js/slider.js');
	}
}
add_action( 'admin_print_scripts', 'designsentry_slide_print_scripts' );

function designsentry_slide_save_order() {
	global $wpdb; // WordPress database class
 
	$order = explode(',', $_POST['order']);
	$counter = 0;
 
	foreach ($order as $sort_id) {
		$wpdb->update($wpdb->posts, array( 'menu_order' => $counter ), array( 'ID' => $sort_id) );
		$counter++;
	}
	die(1);
}
add_action('wp_ajax_slide_sort', 'designsentry_slide_save_order');
?>