<?php
/*wordpress后台设置类文件
*源码库
*http://www.cnymk.com
*/
class ashu_option_class{

	var $options;
	var $pageinfo;
	var $database_options;
	var $saved_optionname;
	
	//类的构建函数
	function ashu_option_class($options, $pageinfo) {
		$this->options = $options;
		$this->pageinfo = $pageinfo;
		$this->make_data_available(); //准备设置选项数据

		add_action( 'admin_menu', array(&$this, 'add_admin_menu') );
		
		if( isset($_GET['page']) && ($_GET['page'] == $this->pageinfo['filename']) ) {
			//加载css js
			add_action('admin_init', array(&$this, 'enqueue_head'));	
		}
	}
	
	function enqueue_head() {
		//加载的js路径
		wp_enqueue_script('ashu_options_js', TEMJS_URI.'ashu_options.js'); 
		wp_enqueue_script('thickbox');
		wp_enqueue_style('thickbox');
	}
	
	//创建菜单项函数
	function add_admin_menu() {
		//添加顶级菜单项
		$top_level = "主题设置";
		if(!$this->pageinfo['child']) {
			add_menu_page($top_level, $top_level, 'edit_themes', $this->pageinfo['filename'], array(&$this, 'initialize'));
			define('TOP_LEVEL_BASEAME', $this->pageinfo['filename']);
		}else{
			add_submenu_page(TOP_LEVEL_BASEAME, $this->pageinfo['full_name'], $this->pageinfo['full_name'], 'edit_themes', $this->pageinfo['filename'], array(&$this, 'initialize'));
		}
	}
	
	function make_data_available() {
		global $ashu_option; //申明全局变量
		
		foreach ($this->options as $option) {
			if( isset($option['std']) ) {
				$ashu_option_std[$this->pageinfo['optionname']][$option['id']] = $option['std'];
			}
		}
		//选项组名称
		$this->saved_optionname = 'ashu_'.$this->pageinfo['optionname'];
		$ashu_option[$this->pageinfo['optionname']] = get_option($this->saved_optionname);
		
		//合并数组
		$ashu_option[$this->pageinfo['optionname']] = array_merge((array)$ashu_option_std[$this->pageinfo['optionname']], (array)$ashu_option[$this->pageinfo['optionname']]);
		
		//html实体转换
		$ashu_option[$this->pageinfo['optionname']] = $this->htmlspecialchars_deep($ashu_option[$this->pageinfo['optionname']]);
	
	}
	
	//使用递归将预定义html实体转换为字符
	function htmlspecialchars_deep($mixed, $quote_style = ENT_QUOTES, $charset = 'UTF-8') {
	    if (is_array($mixed) || is_object($mixed)) {
	        foreach($mixed as $key => $value) {
	            $mixed[$key] = $this->htmlspecialchars_deep($value, $quote_style, $charset);
	        }
	    }
	    elseif (is_string($mixed)) {
	        $mixed = htmlspecialchars_decode($mixed, $quote_style);
	    }
	    return $mixed;
	} 
	
	function initialize() {
		$this->get_save_options();
		$this->display();
	}
	
	//显示表单项函数
	function display() {	
		$saveoption = false;
		echo '<div class="wrap">';
		echo '<div class="icon32" id="icon-options-general"><br/></div>';
		echo '<h2>'.$this->pageinfo['full_name'].'</h2>';
		echo '<form method="post" action="">';
		
		//根据选项类型执行对应函数
		foreach ($this->options as $option) {
			if (method_exists($this, $option['type'])) {
				$this->$option['type']($option);
				$saveoption = true;
			}
		}
		if($saveoption) {
			echo '<p class="submit">';
			echo '<input type="hidden" value="1" name="save_my_options"/>';
			echo '<input type="submit" name="Submit" class="button-primary autowidth" value="Save Changes" /></p>';
		}
		echo '</form></div>';
	}
	
	//更新数据
	function get_save_options() {
		$options = $newoptions  = get_option($this->saved_optionname);
		if ( isset( $_POST['save_my_options'] ) ) {	
			echo '<div class="updated fade" id="message" style=""><p><strong>Settings saved.</strong></p></div>';
			foreach ($_POST as $key => $value) {
				if ( preg_match("/^(malltype_)(\w+_)(\d+)/", $key, $result) ){
					unset( $newoptions );
					break;
				}
			}
			$opion_count = 0;
			foreach ($_POST as $key => $value) {
				if( preg_match("/^(numbers_)/", $key, $result) ){
					$numbers = explode( ',', $value );
					$newoptions[$key] = $numbers;
				}elseif( preg_match("/^(cat_)/", $key, $result) ){
					$newoptions[$key] = $value;
				}elseif( preg_match("/^(tinymce_)/", $key, $result) ){
					$newoptions[$key] = $value;
				}elseif( preg_match("/^(malltype_)(\w+_)(\d+)/", $key, $result) ){
					$kev = 'malltype_'.$result[2].$opion_count;
					$newoptions[$kev] = htmlspecialchars($value, ENT_QUOTES,"UTF-8");
					if( $result[2] == 'name_' ){
						$opion_count++;
					}
				}else{
					$value = stripslashes($value);
					$newoptions[$key] = htmlspecialchars($value, ENT_QUOTES,"UTF-8");
				}
			}
		}
			
		if ( $options != $newoptions ) {
			$options = $newoptions;
			update_option($this->saved_optionname, $options);
		}
		
		if($options) {
			foreach ($options as $key => $value) {
				$options[$key] = empty($options[$key]) ? false : $options[$key];
			}
		}
		
		$this->database_options = $options;
	}
	
	/************开头***************/
	function open($values) {
		if(!isset($values['desc'])) $values['desc'] = "";
		
		echo '<table class="widefat">';
		echo '<thead><tr><th colspan="2">'.$values['desc'].'&nbsp;</th></tr></thead>';
	}
	
	/***************结尾**************/
	function close($values) {
		echo '<tfoot><tr><th>&nbsp;</th><th>&nbsp;</th></tr></tfoot></table>';
	}

	/**********标题***********************/
	function title($values) {
		echo '<h3>'.$values['name'].'</h3>';
		if (isset($values['desc'])) echo '<p>'.$values['desc'].'</p>';
	}

	/*****************************文本域**********************************/
	function textarea($values) {
		if(isset($this->database_options[$values['id']]))
			$values['std'] = $this->database_options[$values['id']];

		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		echo '<textarea name="'.$values['id'].'" cols="60" rows="7" id="'.$values['id'].'" style="width: 80%; font-size: 12px;" class="code">';
		echo $values['std'].'</textarea><br/>';
	    echo '<br/></td>';
		echo '</tr>';
	}
	
		//编辑器
	function tinymce($values){
		if(isset($this->database_options[$values['id']]))
			$values['std'] = $this->database_options[$values['id']];
			
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		wp_editor( $values['std'], $values['id'] );
	    echo '<br/></td>';
		echo '</tr>';
	}
	
	/*********************文本框**************************/
	function text($values) {	
		if(isset($this->database_options[$values['id']])) $values['std'] = $this->database_options[$values['id']];
		
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		echo '<input type="text" size="'.$values['size'].'" value="'.$values['std'].'" id="'.$values['id'].'" name="'.$values['id'].'"/>';
	    echo '<br/><br/></td>';
		echo '</tr>';
	}
	
	/*******************上传*****************************/
	function upload($values) {	
		$prevImg = '';
		if(isset($this->database_options[$values['id']])) $values['std'] = $this->database_options[$values['id']];
		if($values['std'] != ''){$prevImg = '<img src='.$values['std'].' alt="" />';}
		
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>';
		echo '<div class="preview_pic_optionspage" id="'.$values['id'].'_div">'.$prevImg.'</div>';
		echo $values['desc'].'<br/>';
		echo '<input type="text" size="60" value="'.$values['std'].'" name="'.$values['id'].'" class="upload_pic_input" />';
		echo '&nbsp;<a onclick="return false;" title="" class="k_hijack button thickbox" id="'.$values['id'].'" href="media-upload.php?type=image&amp;hijack_target='.$values['id'].'&amp;TB_iframe=true">Insert Image</a>';
		
	    echo '<br/><br/></td>';
		echo '</tr>';
	}

	/**************复选框*******************/
	function checkbox($values) {
		if(isset($this->database_options[$values['id']]) && $this->database_options[$values['id']] !== '')
			$checked = 'checked = "checked"';
		else
			$checked  = '';
		echo '<tr valign="top">';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td><input class="kcheck" type="checkbox" name="'.$values['id'].'" id="'.$values['id'].'" value="true"  '.$checked.' />';
		echo '<label for="'.$values['id'].'">'.$values['desc'].'</label><br/>';
	    echo '<br/></td>';
		echo '</tr>';
	}

	/**********************单选框******************************/
	function radio($values) {
		if(isset($this->database_options[$values['id']])) $values['std'] = $this->database_options[$values['id']];
		
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		
		foreach($values['buttons'] as $key=>$value) {	
			$checked ="";
			if(isset($values['std']) && ($values['std'] == $key)) {
				$checked = 'checked = "checked"';
			}
		
			echo '<p><input '.$checked.' type="radio" class="kcheck" value="'.$key.'" name="'.$values['id'].'"/>';
			echo '<label for="'.$values['id'].'">'.$value.'</label></p>';
		}
		
	    echo '<br/></td>';
		echo '</tr>';
	}
	function zhidinginfo(){
		echo '置顶的文章ID为：'.implode( ',', get_option('sticky_posts'));
	}
	/*****************数组***********************/
	function numbers_array($values){
		if(isset($this->database_options[$values['id']]))
			$values['std'] = $this->database_options[$values['id']];
		else
			$values['std']=array();

		$nums = implode( ',', $values['std'] );
		
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		echo '<input type="text" size="'.$values['size'].'" value="'.$nums.'" id="'.$values['id'].'" name="'.$values['id'].'"/>';
	    echo '<br/><br/></td>';
		echo '</tr>';
	}
	
	function malltype($values){
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'<br />'.$values['desc'].'</th><td>';
		echo "<div class='multitables'>";
		if ( !isset($this->database_options['malltype_count']) ||($this->database_options['malltype_count']== "")){
			$this->database_options['malltype_count'] = 1;
		}

		echo '<input name="malltype_count" class="malltype_count" type="hidden" value="'.$this->database_options['malltype_count'].'" />';
		$count = $this->database_options['malltype_count'] + 1;
		
		for($z = 0; $z < $count; $z++){
			if ( !isset($this->database_options['malltype_title_'.$z])){
				$this->database_options['malltype_title_'.$z]='';
			}
			
			if ( !isset($this->database_options['malltype_name_'.$z])){
				$this->database_options['malltype_name_'.$z]='';
			}
			
			$last = '';
			if ($z+1 == $count) $last = 'hidden clone_me';
			
			echo '<table class="widefat multitable '.$last.'">';
			echo '<thead><tr><th>';
			
			if ($z != 0)
			{
				echo '<a href="#" class="del_table" id="del_number_'.($z + 1).'" >删除</a>';
			} 
			
			echo '</th><th>&nbsp;</th></tr></thead><tbody>';
			echo '<tr valign="top">';
			echo '<th scope="row">商家类型<span class="changenumber">'.($z+1).'</span></th><td>';
			
			echo '类型名称';
			echo '<input class="changeable" type="text" size="40" value="'.$this->database_options['malltype_title_'.$z].'" id="malltype_title_'.$z.'" name="malltype_title_'.$z.'"/><br/>';
			
			echo '<br />';
			
			echo '类型别名';
			echo '<input class="changeable" type="text" size="40" value="'.$this->database_options['malltype_name_'.$z].'" id="malltype_name_'.$z.'" name="malltype_name_'.$z.'"/><br/>';
			echo '<br/></td></tr></tbody>';
			
			echo '<tfoot><tr><th><a href="#" class="add_table" id="number_'.($z+1).'" >添加</a></th><th>&nbsp;</th></tr></tfoot>';
			echo '</table>';
		}
		echo '</div>'; 
		echo '</td>';
		echo '</tr>';
	}
	
	/*****************分类选择**********************/
	function cat_dropdown($values){
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th><td>';
		$select = 'Select category';
		$entries = get_categories('orderby=name&hide_empty=0');
		if(isset($this->database_options[$values['id'].'_id']))
			$cat_id = $this->database_options[$values['id'].'_id'];
		else
			$cat_id = '';
		if(isset($this->database_options[$values['id'].'_count']))
			$count = $this->database_options[$values['id'].'_count'];
		else
			$count = '';
		echo '<label for="'.$values['id'].'_id">选择分类</label>';
		echo '<select class="postform" id="'. $values['id'] .'_id" name="'. $values['id'] .'_id"> ';
		echo '<option value="">'.$select .'</option>  ';
		foreach ($entries as $key => $entry) {
			$id = $entry->term_id;
			$title = $entry->name;
			if ( $cat_id == $id ){
				$selected = "selected='selected'";
			}else{
				$selected = "";
			}
			
			echo"<option $selected value='". $id."'>". $title."</option>";
		}
		echo '</select>';
		echo '&nbsp;&nbsp;&nbsp;&nbsp;<label for="'.$values['id'].'_count">显示数量</label>';
		echo '<input class="count" type="text" size="5" value="'.$count.'" id="'.$values['id'].'_count" name="'.$values['id'].'_count"/>';
		echo '<br/><br/></td>';
		echo '</tr>';
	}

	/********************下拉框*********************/
	function dropdown($values) {	
		if(!isset($this->database_options[$values['id']]) && isset($values['std'])) $this->database_options[$values['id']] = $values['std'];
				
		echo '<tr valign="top" >';
		echo '<th scope="row" width="200px">'.$values['name'].'</th>';
		echo '<td>'.$values['desc'].'<br/>';
		
			if($values['subtype'] == 'page') {
				$select = 'Select page';
				$entries = get_pages('title_li=&orderby=name');
			}
			else if($values['subtype'] == 'sidebar'){
				global $wp_registered_sidebars;
				$select = 'Select a special sidebar';
				$entries = $wp_registered_sidebars;
			}
			else if($values['subtype'] == 'cat')
			{
				$select = 'Select category';
				$entries = get_categories('title_li=&orderby=name&hide_empty=0');
			}
			else
			{	
				$select = 'Select...';
				$entries = $values['subtype'];
			}
		
			echo '<select class="postform" id="'. $values['id'] .'" name="'. $values['id'] .'"> ';
			echo '<option value="">'.$select .'</option>  ';

			foreach ($entries as $key => $entry) {
				if($values['subtype'] == 'page')
				{
					$id = $entry->ID;
					$title = $entry->post_title;
				}
				else if($values['subtype'] == 'cat')
				{
					$id = $entry->term_id;
					$title = $entry->name;
				}else if($values['subtype'] == 'sidebar'){
					$id = $entry['id'];
					$title = $entry['name'];
				}
				else
				{
					$id = $key;	
					$title = $entry;		
				}

				if ($this->database_options[$values['id']] == $id )
				{
					$selected = "selected='selected'";	
				}
				else
				{
					$selected = "";		
				}
				
				echo"<option $selected value='". $id."'>". $title."</option>";
			}
		echo '</select>';
		 
	    echo '<br/><br/></td>';
		echo '</tr>';
	}
}
?>