<?php

if ( !function_exists('wp_new_user_notification') ) :
function wp_new_user_notification($user_id, $plaintext_pass = '') {
$user = new WP_User($user_id);
    
if (get_option('wp_forest_login_register_admin_registration_send_email'))
{
$adminurl = '/wp-admin';
$referer = strtolower(wp_get_referer());
if (strlen($_REQUEST["pass1"]) > 0 && wp_verify_nonce($_REQUEST['_wpnonce'], 'add-user') && strstr($referer, $adminurl))
$plaintext_pass = $_REQUEST["pass1"];
}
    
$user_login = stripslashes($user->user_login);
$user_email = stripslashes($user->user_email);
$find = array('/##username##/i', '/##password##/i', '/##blogname##/i', '/##siteurl##/i', '/##loginurl##/i', '/##useremail##/i');
$replace = array($user_login, $plaintext_pass, get_settings('blogname'), site_url(), get_option('siteurl').'/wp-login.php', $user_email);
    
$headers = "MIME-Version: 1.0\n" .
"From: ". $user_email . "\n" . 
"Content-Type: text/plain; charset=\"" . get_settings('blog_charset') . "\"\n";

$subject = get_settings("wp_forest_login_register_admin_email_subject");
$subject = preg_replace($find, $replace, $subject);
$subject = preg_replace("/##.*##/", "", $subject);	//get rid of any remaining variables
    
$message = get_settings('wp_forest_login_register_admin_email');
$message = preg_replace($find, $replace, $message);
$message = preg_replace("/##.*##/", "", $message);	//get rid of any remaining variables
@wp_mail(get_settings('admin_email'), $subject, $message, $headers);

if ( empty($plaintext_pass) )
return;
$headers = "MIME-Version: 1.0\n" .
"From: ". get_settings("wp_forest_login_register_from_email_address") . "\n" . 
"Content-Type: text/plain; charset=\"" . get_settings('blog_charset') . "\"\n";
        
$subject = get_settings("wp_forest_login_register_user_email_subject");
$subject = preg_replace($find, $replace, $subject);
$subject = preg_replace("/##.*##/", "", $subject);	//get rid of any remaining variables
    
$message = get_settings('wp_forest_login_register_user_email');
$message = preg_replace($find, $replace, $message);
$message = preg_replace("/##.*##/", "", $message);	//get rid of any remaining variables
		
wp_mail($user_email, $subject, $message, $headers);
}
endif;

if ( !function_exists('my_retrieve_password') ) :
function my_retrieve_password()
{
global $current_theme_locale_name, $wpdb, $current_site;
$errors = new WP_Error();
if ( empty( $_POST['user_login'] ) ) {
$errors->add('empty_username', __('<strong>ERROR</strong>: Enter a username or e-mail address.', $current_theme_locale_name));
} else if ( strpos( $_POST['user_login'], '@' ) ) {
$user_data = get_user_by( 'email', trim( $_POST['user_login'] ) );
if ( empty( $user_data ) )
$errors->add('invalid_email', __('<strong>ERROR</strong>: There is no user registered with that email address.', $current_theme_locale_name));
} else {
$login = trim($_POST['user_login']);
$user_data = get_user_by('login', $login);
}

do_action('lostpassword_post');
if ( $errors->get_error_code() )
return $errors;
if ( !$user_data ) {
$errors->add('invalidcombo', __('<strong>ERROR</strong>: Invalid username or e-mail.', $current_theme_locale_name));
return $errors;
}

// redefining user_login ensures we return the right case in the email
$user_login = $user_data->user_login;
$user_email = $user_data->user_email;

do_action('retreive_password', $user_login);  // Misspelled and deprecated
do_action('retrieve_password', $user_login);

$allow = apply_filters('allow_password_reset', true, $user_data->ID);

if ( ! $allow )
return new WP_Error('no_password_reset', __('Password reset is not allowed for this user', $current_theme_locale_name));
else if ( is_wp_error($allow) )
return $allow;

$key = $wpdb->get_var($wpdb->prepare("SELECT user_activation_key FROM $wpdb->users WHERE user_login = %s", $user_login));
if ( empty($key) ) {
// Generate something random for a key...
$key = wp_generate_password(20, false);
do_action('retrieve_password_key', $user_login, $key);
// Now insert the new md5 key into the db
$wpdb->update($wpdb->users, array('user_activation_key' => $key), array('user_login' => $user_login));
}
$message = __('Someone requested that the password be reset for the following account:', $current_theme_locale_name) . "\r\n\r\n";
$message .= network_site_url() . "\r\n\r\n";
$message .= sprintf(__('Username: %s', $current_theme_locale_name), $user_login) . "\r\n\r\n";
$message .= __('If this was a mistake, just ignore this email and nothing will happen.', $current_theme_locale_name) . "\r\n\r\n";
$message .= __('To reset your password, visit the following address:' ,$current_theme_locale_name) . "\r\n\r\n";
$message .= '<' . network_site_url("wp-login.php?action=rp&key=$key&login=" . rawurlencode($user_login), 'login') . ">\r\n";

if ( is_multisite() )
$blogname = $GLOBALS['current_site']->site_name;
else
// The blogname option is escaped with esc_html on the way into the database in sanitize_option
// we want to reverse this for the plain text arena of emails.
$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);

$title = sprintf( __('[%s] Password Reset'), $blogname );

$title = apply_filters('retrieve_password_title', $title);
$message = apply_filters('retrieve_password_message', $message, $key);

if ( $message && !wp_mail($user_email, $title, $message) )
wp_die( __('The e-mail could not be sent.', $current_theme_locale_name) . "<br />\n" . __('Possible reason: your host may have disabled the 
mail() function...', $current_theme_locale_name) );
}
endif;
?>